/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.jive;

import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.http.HttpAuthenticatorFactory;
import com.atlassian.crowd.integration.jive.CrowdAuthToken;
import com.atlassian.crowd.integration.jive.CrowdUser;
import com.jivesoftware.base.AuthFactory;
import com.jivesoftware.base.AuthToken;
import com.jivesoftware.base.JiveGlobals;
import com.jivesoftware.base.Log;
import com.jivesoftware.base.UnauthorizedException;
import com.jivesoftware.base.UserNotFoundException;
import com.jivesoftware.base.ban.Ban;
import com.jivesoftware.base.ban.BanDAO;
import com.jivesoftware.base.ban.BanDAOFactory;
import com.jivesoftware.base.ban.BanLevel;
import com.jivesoftware.base.database.ConnectionManager;
import com.jivesoftware.base.registration.RegistrationManager;
import com.jivesoftware.base.registration.RegistrationManagerImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CrowdAuthFactory
extends AuthFactory {
    private static final Logger LOGGER = Logger.getLogger(CrowdAuthFactory.class);
    private static final String FIND_USER_ID = "SELECT userID FROM jiveUser WHERE username=?";
    private RegistrationManager jiveRegistrationManager = RegistrationManagerImpl.getInstance();
    private BanDAO jiveBanDAO = BanDAOFactory.getInstance();
    private final HttpAuthenticator httpAuthenticator;

    public CrowdAuthFactory(HttpAuthenticator httpAuthenticator) {
        LOGGER.debug((Object)"Creating a new CrowdAuthFactory.");
        this.httpAuthenticator = httpAuthenticator;
    }

    public CrowdAuthFactory() {
        this(HttpAuthenticatorFactory.getHttpAuthenticator());
    }

    protected AuthToken createAuthToken(HttpServletRequest request, HttpServletResponse response) throws UnauthorizedException {
        LOGGER.debug((Object)">> createAuthToken(req, resp)");
        String crowdUser = null;
        try {
            if (this.httpAuthenticator.isAuthenticated(request, response)) {
                crowdUser = this.httpAuthenticator.getPrincipal(request).getName();
            } else {
                String username = request.getParameter("username");
                String password = request.getParameter("password");
                this.httpAuthenticator.authenticate(request, response, username, password);
                crowdUser = username;
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Error occurred while trying to authenticate request", (Throwable)e);
        }
        if (crowdUser != null) {
            AuthToken authToken;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Request is authenticated with Crowd for user " + crowdUser));
            }
            if ((authToken = (AuthToken)request.getSession().getAttribute("jive.authToken")) instanceof CrowdAuthToken) {
                LOGGER.debug((Object)"Request has associated Jive session");
                if (crowdUser.equals(((CrowdAuthToken)authToken).getUsername())) {
                    LOGGER.debug((Object)"Jive session principal matches Crowd principal. Returning Jive session's stored CrowdAuthToken");
                    return authToken;
                }
                LOGGER.debug((Object)"Jive session principal does not match Crowd principal");
            } else {
                LOGGER.debug((Object)"Request has no associated Jive session");
            }
            CrowdAuthToken newAuthToken = this.authenticateCrowdPrincipalWithJive(crowdUser, request);
            LOGGER.debug((Object)"Adding new CrowdAuthToken to associated Jive session and returning the CrowdAuthToken");
            request.getSession().setAttribute("jive.authToken", (Object)newAuthToken);
            return newAuthToken;
        }
        LOGGER.debug((Object)"Request is not authenticated with Crowd");
        throw new UnauthorizedException("User could not be authenticated");
    }

    private long findOrCreateCrowdPrincipalInJive(String username) throws UnauthorizedException {
        long userID;
        boolean createNewUser;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block10: {
            con = null;
            pstmt = null;
            rs = null;
            createNewUser = false;
            userID = -1L;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Searching for user " + username + " in Jive's DB"));
            }
            try {
                con = ConnectionManager.getConnection();
                pstmt = con.prepareStatement(FIND_USER_ID);
                String lowerUsername = username == null ? "" : username.toLowerCase();
                pstmt.setString(1, lowerUsername);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    userID = rs.getLong(1);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Found userID " + userID + " based on query: " + FIND_USER_ID + ", using username: " + username));
                    }
                    break block10;
                }
                LOGGER.debug((Object)"Could not find user in Jive's DB");
                createNewUser = true;
            }
            catch (Exception e) {
                try {
                    LOGGER.debug((Object)"Exception while retrieving user info from the Jive DB.");
                    throw new UnauthorizedException((Throwable)e);
                }
                catch (Throwable throwable) {
                    ConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
            }
        }
        ConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        if (createNewUser) {
            LOGGER.debug((Object)"Creating user in Jive's DB");
            try {
                userID = new CrowdUser(username).getID();
            }
            catch (UserNotFoundException e) {
                LOGGER.debug((Object)"Exception while retrieving user info from the Jive DB.");
                throw new UnauthorizedException((Throwable)e);
            }
            LOGGER.debug((Object)"Created Crowd user in Jive DB");
        }
        return userID;
    }

    private CrowdAuthToken authenticateCrowdPrincipalWithJive(String username, HttpServletRequest request) throws UnauthorizedException {
        long userID = this.findOrCreateCrowdPrincipalInJive(username);
        if (this.isAllowedToLoginToJive(userID, request.getRemoteAddr())) {
            LOGGER.debug((Object)"User is allowed to log into Jive (isn't on any ban list)");
            CrowdAuthToken authToken = new CrowdAuthToken(userID, username);
            request.getSession().setAttribute("jive.authToken", (Object)authToken);
            LOGGER.debug((Object)"CrowdAuthToken created and associated with Jive session. Returning new token.");
            return authToken;
        }
        LOGGER.debug((Object)"User is not allowed to log into Jive (on a ban list or account validation failed)");
        throw new UnauthorizedException("User is not allowed to log into Jive (on a ban list or account validation failed)");
    }

    private boolean isAllowedToLoginToJive(long userID, String remoteAddress) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Checking if userID " + userID + " with address " + remoteAddress + " is allowed to login to Jive"));
        }
        try {
            if (!this.jiveRegistrationManager.isAccountValidated(userID)) {
                LOGGER.debug((Object)"Jive's account validation failed for user. User not allowed to login");
                return false;
            }
        }
        catch (UserNotFoundException e) {
            Log.debug((String)"Unexpected UserNotFoundException. User not allowed to login", (Throwable)e);
            return false;
        }
        if (JiveGlobals.getJiveBooleanProperty((String)"banneduser.enabled")) {
            Ban ban = this.jiveBanDAO.getBan(userID, BanLevel.BAN_LOGIN);
            if (ban != null) {
                LOGGER.debug((Object)"User appears on Jive's ban list. User not allowed to login");
                return false;
            }
            ban = this.jiveBanDAO.getBan(remoteAddress, BanLevel.BAN_LOGIN);
            if (ban != null) {
                LOGGER.debug((Object)"Remote address appears on Jive's ban list. User not allowed to login");
                return false;
            }
        }
        return true;
    }

    protected AuthToken createSessionUserInfo(String username, String password, boolean autoLogin, HttpServletRequest request, HttpServletResponse response) throws UnauthorizedException {
        LOGGER.debug((Object)"Authenticating user to Crowd and Jive");
        if (username != null && password != null) {
            try {
                this.httpAuthenticator.authenticate(request, response, username, password);
                LOGGER.debug((Object)"Authentication to Crowd successful");
                CrowdAuthToken newAuthToken = this.authenticateCrowdPrincipalWithJive(username, request);
                LOGGER.debug((Object)"Authentication to Jive successful");
                return newAuthToken;
            }
            catch (Exception e) {
                LOGGER.debug((Object)"Error authenticating user by using explicitly provided username/password", (Throwable)e);
                throw new UnauthorizedException("Error authenticating user by using explicitly provided username/password", (Throwable)e);
            }
        }
        throw new UnauthorizedException("Username or password is null");
    }

    protected void clearSessionUserInfo(HttpServletRequest request, HttpServletResponse response) {
        super.clearSessionUserInfo(request, response);
        try {
            this.httpAuthenticator.logoff(request, response);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Could log out of Crowd", (Throwable)e);
        }
    }

    public AuthToken createAuthToken(String username, String password) throws UnauthorizedException {
        LOGGER.debug((Object)">> createAuthToken(username, password)");
        try {
            LOGGER.debug((Object)("Authenticating user with Crowd: " + username));
            this.httpAuthenticator.verifyAuthentication(username, password);
            LOGGER.debug((Object)("Finding/creating Crowd user in Jive: " + username));
            long userID = this.findOrCreateCrowdPrincipalInJive(username);
            LOGGER.debug((Object)("Generating non-SSO token for user: " + username));
            return new CrowdAuthToken(userID, username);
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Non-SSO authentication failed for user: " + username), (Throwable)e);
            throw new UnauthorizedException((Throwable)e);
        }
    }

    public AuthToken createAnonymousAuthToken() {
        return new CrowdAuthToken(-1L, null);
    }
}

