/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.atlassianuser;

import com.atlassian.crowd.integration.atlassianuser.AbstractManager;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultGroup;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.ehcache.CacheException;
import org.apache.log4j.Logger;

public class CrowdGroupManager
extends AbstractManager
implements GroupManager {
    private static final Logger logger = Logger.getLogger(CrowdGroupManager.class);
    private final RepositoryIdentifier repositoryIdentifier;

    public CrowdGroupManager(RepositoryIdentifier repositoryIdentifier) {
        this(repositoryIdentifier, SecurityServerClientFactory.getSecurityServerClient());
    }

    public CrowdGroupManager(RepositoryIdentifier repositoryIdentifier, SecurityServerClient securityServerClient) {
        super(securityServerClient);
        this.repositoryIdentifier = repositoryIdentifier;
    }

    public Pager getGroups() throws EntityException {
        try {
            List crowdGroupNames = this.findAllGroupNames();
            ArrayList<DefaultGroup> groups = new ArrayList<DefaultGroup>(crowdGroupNames.size());
            for (String name : crowdGroupNames) {
                DefaultGroup group = new DefaultGroup(name);
                groups.add(group);
            }
            return new DefaultPager(groups);
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public Pager getGroups(User user) throws EntityException {
        return new DefaultPager((Collection)this.getGroupMembership(user));
    }

    protected List getGroupMembership(User user) throws EntityException {
        try {
            if (this.getCacheManager().isCacheEnabled()) {
                try {
                    return this.getCacheManager().getPrincipalMemberships(user.getName());
                }
                catch (CacheException e) {
                    // empty catch block
                }
            }
            List<String> groupNames = Arrays.asList(this.securityServerClient.findGroupMemberships(user.getName()));
            ArrayList<DefaultGroup> memberships = new ArrayList<DefaultGroup>(groupNames.size());
            for (String name : groupNames) {
                memberships.add(new DefaultGroup(name));
            }
            if (this.getCacheManager().isCacheEnabled()) {
                this.getCacheManager().cachePrincipalMemberships(user.getName(), memberships);
            }
            return memberships;
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public Pager getMemberNames(Group group) throws EntityException {
        try {
            SOAPGroup crowdgroup = this.findGroupByName(group.getName());
            return new DefaultPager(Arrays.asList(crowdgroup.getMembers()));
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        return this.getMemberNames(group);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        return new DefaultPager(new ArrayList(0));
    }

    public Group getGroup(String name) throws EntityException {
        try {
            List groupnames = this.findAllGroupNames();
            if (groupnames.contains(name)) {
                return new DefaultGroup(name);
            }
            return null;
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public Group createGroup(String name) throws EntityException {
        try {
            SOAPGroup group = new SOAPGroup();
            group.setActive(true);
            group.setDescription("");
            group.setName(name);
            this.securityServerClient.addGroup(group);
            this.getCacheManager().flushCaches();
            return this.getGroup(name);
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeGroup(Group group) throws EntityException {
        try {
            this.findGroupByName(group.getName());
            this.getCacheManager().flushCaches();
        }
        catch (ObjectNotFoundException e) {
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
        try {
            this.securityServerClient.removeGroup(group.getName());
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public void addMembership(Group group, User user) throws EntityException {
        try {
            this.securityServerClient.addPrincipalToGroup(user.getName(), group.getName());
            this.getCacheManager().flushCaches();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        try {
            List groups = this.getGroupMembership(user);
            return groups.contains(group);
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeMembership(Group group, User user) throws EntityException {
        try {
            this.securityServerClient.removePrincipalFromGroup(user.getName(), group.getName());
            this.getCacheManager().flushCaches();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean supportsExternalMembership() throws EntityException {
        return false;
    }

    public boolean isReadOnly(Group group) throws EntityException {
        return false;
    }

    public RepositoryIdentifier getIdentifier() {
        return this.repositoryIdentifier;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (this.getGroup(entity.getName()) != null) {
            return this.repositoryIdentifier;
        }
        return null;
    }

    public boolean isCreative() {
        return true;
    }

    protected List findAllGroupNames() throws InvalidAuthorizationTokenException, RemoteException {
        if (this.getCacheManager().isCacheEnabled()) {
            try {
                return this.getCacheManager().getGroupNames();
            }
            catch (CacheException e) {
                // empty catch block
            }
        }
        List<String> groupNames = Arrays.asList(this.securityServerClient.findAllGroupNames());
        if (this.getCacheManager().isCacheEnabled()) {
            this.getCacheManager().cacheGroupNames(groupNames);
        }
        return groupNames;
    }

    protected SOAPGroup findGroupByName(String name) throws InvalidAuthorizationTokenException, RemoteException, ObjectNotFoundException {
        if (this.getCacheManager().isCacheEnabled()) {
            try {
                return this.getCacheManager().getGroup(name);
            }
            catch (CacheException e) {
                // empty catch block
            }
        }
        SOAPGroup group = this.securityServerClient.findGroupByName(name);
        if (this.getCacheManager().isCacheEnabled()) {
            this.getCacheManager().cacheGroup(group);
        }
        return group;
    }
}

