/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.acegi;

import com.atlassian.crowd.integration.acegi.CrowdDataAccessException;
import com.atlassian.crowd.integration.acegi.CrowdUserDetails;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import java.rmi.RemoteException;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;

public class CrowdUserDetailsService
implements UserDetailsService {
    protected static final Logger LOGGER = Logger.getLogger(CrowdUserDetails.class);
    private SecurityServerClient securityServerClient;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        try {
            SOAPPrincipal principal = this.securityServerClient.findPrincipalByName(username);
            return new CrowdUserDetails(principal, this.securityServerClient);
        }
        catch (InvalidAuthorizationTokenException e) {
            LOGGER.error((Object)e);
            throw new CrowdDataAccessException(e);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)e);
            throw new CrowdDataAccessException(e);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.info((Object)("Could not find principal in Crowd with username: " + username));
            throw new UsernameNotFoundException("Could not find principal in Crowd with username: " + username, (Throwable)e);
        }
    }

    public SecurityServerClient getSecurityServerClient() {
        return this.securityServerClient;
    }

    public void setSecurityServerClient(SecurityServerClient securityServerClient) {
        this.securityServerClient = securityServerClient;
    }
}

