/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.acegi;

import com.atlassian.crowd.integration.acegi.CrowdAuthenticationDetails;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import java.rmi.RemoteException;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.DisabledException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.AbstractUserDetailsAuthenticationProvider;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSourceAware;
import org.springframework.dao.DataAccessException;

public class CrowdAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider
implements InitializingBean,
MessageSourceAware {
    private static final Log logger = LogFactory.getLog(CrowdAuthenticationProvider.class);
    private HttpAuthenticator httpAuthenticator;
    private SecurityServerClient securityServerClient;
    private UserDetailsService userDetailsService;

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        block15: {
            if (authentication.getPrincipal() == null || authentication.getCredentials() == null) {
                throw new BadCredentialsException("UsernamePasswordAuthenticationToken contains null username or password");
            }
            String username = authentication.getPrincipal().toString();
            String password = authentication.getCredentials().toString();
            if (StringUtils.isEmpty((String)userDetails.getUsername())) {
                throw new AuthenticationServiceException("UserDetails contains empty username");
            }
            if (StringUtils.isEmpty((String)username)) {
                throw new BadCredentialsException("UsernamePasswordAuthenticationToken contains empty username");
            }
            if (!userDetails.getUsername().equals(username)) {
                throw new AuthenticationServiceException("Username in UserDetails does not match UsernamePasswordAuthenticationToken");
            }
            try {
                if (authentication.getDetails() != null && authentication.getDetails() instanceof CrowdAuthenticationDetails) {
                    CrowdAuthenticationDetails details = (CrowdAuthenticationDetails)((Object)authentication.getDetails());
                    if (details.getToken() == null) {
                        String token = this.httpAuthenticator.verifyAuthentication(username, password, details.getValidationFactors());
                        if (token == null) {
                            throw new AuthenticationServiceException("Crowd server returned a null authentication token");
                        }
                        details.setToken(token);
                        break block15;
                    }
                    try {
                        SOAPPrincipal ssoPrincipal = this.securityServerClient.findPrincipalByToken(details.getToken());
                        if (!username.equals(ssoPrincipal.getName())) {
                            throw new BadCredentialsException("SSO user is not the same as the user requesting authentication");
                        }
                        break block15;
                    }
                    catch (InvalidTokenException e) {
                        throw new AuthenticationServiceException("Invalid token used for SSO Crowd authentication");
                    }
                }
                this.httpAuthenticator.verifyAuthentication(username, password);
            }
            catch (InvalidAuthorizationTokenException e) {
                logger.error((Object)e);
                throw new AuthenticationServiceException(e.getMessage(), (Throwable)e);
            }
            catch (InvalidAuthenticationException e) {
                logger.debug((Object)e);
                throw new BadCredentialsException(e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                logger.error((Object)e);
                throw new AuthenticationServiceException(e.getMessage(), (Throwable)e);
            }
            catch (InactiveAccountException e) {
                logger.info((Object)e);
                throw new DisabledException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        try {
            return this.getUserDetailsService().loadUserByUsername(username);
        }
        catch (DataAccessException e) {
            logger.error((Object)e);
            throw new AuthenticationServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public HttpAuthenticator getHttpAuthenticator() {
        return this.httpAuthenticator;
    }

    public void setHttpAuthenticator(HttpAuthenticator httpAuthenticator) {
        this.httpAuthenticator = httpAuthenticator;
    }

    public SecurityServerClient getSecurityServerClient() {
        return this.securityServerClient;
    }

    public void setSecurityServerClient(SecurityServerClient securityServerClient) {
        this.securityServerClient = securityServerClient;
    }
}

