/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.acegi;

import com.atlassian.crowd.integration.acegi.CrowdAuthenticationDetails;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.ui.webapp.AuthenticationProcessingFilter;
import org.acegisecurity.userdetails.UserDetails;

public class CrowdAuthenticationProcessingFilter
extends AuthenticationProcessingFilter {
    private HttpAuthenticator httpAuthenticator;

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean uriSaysToAuthenticate = super.requiresAuthentication(request, response);
        boolean ssoSaysToAuthenticate = false;
        if (!uriSaysToAuthenticate) {
            String crowdUser = this.getCrowdUsername(request);
            String acegiUser = this.getAcegiUsername(SecurityContextHolder.getContext().getAuthentication());
            ssoSaysToAuthenticate = crowdUser == null ? acegiUser != null : !crowdUser.equals(acegiUser);
        }
        return uriSaysToAuthenticate || ssoSaysToAuthenticate;
    }

    protected String getCrowdUsername(HttpServletRequest request) {
        try {
            return this.httpAuthenticator.getPrincipal(request).getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getAcegiUsername(Authentication acegiAuth) {
        String acegiUser = acegiAuth == null || acegiAuth instanceof AnonymousAuthenticationToken || acegiAuth.getPrincipal() == null ? null : (acegiAuth.getPrincipal() instanceof String ? acegiAuth.getPrincipal().toString() : (acegiAuth.getPrincipal() instanceof UserDetails ? ((UserDetails)acegiAuth.getPrincipal()).getUsername() : null));
        return acegiUser;
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        authRequest.setDetails((Object)new CrowdAuthenticationDetails(request, this.httpAuthenticator));
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        CrowdAuthenticationDetails details;
        if (authResult.getDetails() instanceof CrowdAuthenticationDetails && (details = (CrowdAuthenticationDetails)((Object)authResult.getDetails())).getToken() != null) {
            try {
                this.httpAuthenticator.setPrincipalToken(request, response, details.getToken());
            }
            catch (InvalidAuthorizationTokenException e) {
                this.logger.error((Object)"Unable to set Crowd SSO token", (Throwable)e);
            }
        }
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        try {
            this.httpAuthenticator.logoff(request, response);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.logger.error((Object)"Unable to unset Crowd SSO token", (Throwable)e);
        }
    }

    protected String obtainUsername(HttpServletRequest request) {
        String username = super.obtainUsername(request);
        if (username == null) {
            username = this.getCrowdUsername(request);
        }
        return username;
    }

    public HttpAuthenticator getHttpAuthenticator() {
        return this.httpAuthenticator;
    }

    public void setHttpAuthenticator(HttpAuthenticator httpAuthenticator) {
        this.httpAuthenticator = httpAuthenticator;
    }
}

