/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.integration.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.integration.authentication.AuthenticatedToken;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public class SoapObjectTranslator {
    public static final Function<com.atlassian.crowd.integration.authentication.ValidationFactor, ValidationFactor> FROM_SOAP_VALIDATION_FACTOR_FUNCTION = new Function<com.atlassian.crowd.integration.authentication.ValidationFactor, ValidationFactor>(){

        public ValidationFactor apply(com.atlassian.crowd.integration.authentication.ValidationFactor validationFactor) {
            return SoapObjectTranslator.fromSoapValidationFactor(validationFactor);
        }
    };
    public static final Function<ValidationFactor, com.atlassian.crowd.integration.authentication.ValidationFactor> TO_SOAP_VALIDATION_FACTOR_FUNCTION = new Function<ValidationFactor, com.atlassian.crowd.integration.authentication.ValidationFactor>(){

        public com.atlassian.crowd.integration.authentication.ValidationFactor apply(ValidationFactor validationFactor) {
            return SoapObjectTranslator.toSoapValidationFactor(validationFactor);
        }
    };

    public static com.atlassian.crowd.integration.authentication.PasswordCredential toSoapPasswordCredential(PasswordCredential passwordCredential) {
        if (passwordCredential == null) {
            return null;
        }
        return new com.atlassian.crowd.integration.authentication.PasswordCredential(passwordCredential.getCredential(), passwordCredential.isEncryptedCredential());
    }

    public static PasswordCredential fromSoapPasswordCredential(com.atlassian.crowd.integration.authentication.PasswordCredential passwordCredential) {
        if (passwordCredential == null) {
            return null;
        }
        return new PasswordCredential(passwordCredential.getCredential(), passwordCredential.isEncryptedCredential());
    }

    public static com.atlassian.crowd.integration.authentication.ValidationFactor toSoapValidationFactor(ValidationFactor validationFactor) {
        if (validationFactor == null) {
            return null;
        }
        return new com.atlassian.crowd.integration.authentication.ValidationFactor(validationFactor.getName(), validationFactor.getValue());
    }

    public static ValidationFactor fromSoapValidationFactor(com.atlassian.crowd.integration.authentication.ValidationFactor validationFactor) {
        if (validationFactor == null) {
            return null;
        }
        return new ValidationFactor(validationFactor.getName(), validationFactor.getValue());
    }

    public static com.atlassian.crowd.integration.authentication.ValidationFactor[] toSoapValidationFactors(ValidationFactor[] validationFactors) {
        if (validationFactors == null) {
            return null;
        }
        List result = Lists.transform(Arrays.asList(validationFactors), TO_SOAP_VALIDATION_FACTOR_FUNCTION);
        return (com.atlassian.crowd.integration.authentication.ValidationFactor[])Iterables.toArray((Iterable)result, com.atlassian.crowd.integration.authentication.ValidationFactor.class);
    }

    public static ValidationFactor[] fromSoapValidationFactors(com.atlassian.crowd.integration.authentication.ValidationFactor[] validationFactors) {
        if (validationFactors == null) {
            return null;
        }
        List result = Lists.transform((List)ImmutableList.copyOf((Object[])validationFactors), FROM_SOAP_VALIDATION_FACTOR_FUNCTION);
        return (ValidationFactor[])Iterables.toArray((Iterable)result, ValidationFactor.class);
    }

    public static AuthenticatedToken toSoapAuthenticatedToken(com.atlassian.crowd.model.authentication.AuthenticatedToken authenticatedToken) {
        if (authenticatedToken == null) {
            return null;
        }
        return new AuthenticatedToken(authenticatedToken.getName(), authenticatedToken.getToken());
    }

    public static com.atlassian.crowd.model.authentication.AuthenticatedToken fromSoapAuthenticatedToken(AuthenticatedToken authenticatedToken) {
        if (authenticatedToken == null) {
            return null;
        }
        return new com.atlassian.crowd.model.authentication.AuthenticatedToken(authenticatedToken.getName(), authenticatedToken.getToken());
    }

    public static com.atlassian.crowd.integration.authentication.UserAuthenticationContext toSoapUserAuthenticationContext(UserAuthenticationContext context) {
        if (context == null) {
            return null;
        }
        return new com.atlassian.crowd.integration.authentication.UserAuthenticationContext(context.getName(), SoapObjectTranslator.toSoapPasswordCredential(context.getCredential()), SoapObjectTranslator.toSoapValidationFactors(context.getValidationFactors()), context.getApplication());
    }

    public static UserAuthenticationContext fromSoapUserAuthenticationContext(com.atlassian.crowd.integration.authentication.UserAuthenticationContext context) {
        if (context == null) {
            return null;
        }
        return new UserAuthenticationContext(context.getName(), SoapObjectTranslator.fromSoapPasswordCredential(context.getCredential()), SoapObjectTranslator.fromSoapValidationFactors(context.getValidationFactors()), context.getApplication());
    }

    public static ApplicationAuthenticationContext toSoapApplicationAuthenticationContext(com.atlassian.crowd.model.authentication.ApplicationAuthenticationContext context) {
        if (context == null) {
            return null;
        }
        return new ApplicationAuthenticationContext(context.getName(), SoapObjectTranslator.toSoapPasswordCredential(context.getCredential()), SoapObjectTranslator.toSoapValidationFactors(context.getValidationFactors()));
    }

    public static com.atlassian.crowd.model.authentication.ApplicationAuthenticationContext fromSoapApplicationAuthenticationContext(ApplicationAuthenticationContext context) {
        if (context == null) {
            return null;
        }
        return new com.atlassian.crowd.model.authentication.ApplicationAuthenticationContext(context.getName(), SoapObjectTranslator.fromSoapPasswordCredential(context.getCredential()), SoapObjectTranslator.fromSoapValidationFactors(context.getValidationFactors()));
    }
}

