/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.cache;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.service.GroupManager;
import com.atlassian.crowd.service.GroupMembershipManager;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.BasicCache;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.util.NestingHelper;
import com.google.common.base.Preconditions;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class CachingGroupMembershipManager
implements GroupMembershipManager {
    private final Server server;
    private final GroupManager groupManager;
    private final UserManager userManager;
    private final BasicCache basicCache;

    public CachingGroupMembershipManager(SecurityServerClient securityServerClient, UserManager userManager, GroupManager groupManager, BasicCache basicCache) {
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.basicCache = basicCache;
        this.server = new Server(securityServerClient);
    }

    @Override
    public boolean isMember(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)groupName);
        Boolean isMember = this.basicCache.isMember(userName, groupName);
        if (isMember == null) {
            isMember = this.basicCache.isMemberInGroupCache(userName, groupName);
            if (isMember == null) {
                isMember = this.server.isMember(userName, groupName);
            }
            this.basicCache.setMembership(userName, groupName, isMember);
        }
        return isMember;
    }

    @Override
    public void addMembership(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, InvalidAuthenticationException, UserNotFoundException, GroupNotFoundException {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)groupName);
        this.server.addMembership(userName, groupName);
        this.getMemberships(userName);
        this.getMembers(groupName);
        this.basicCache.setMembership(userName, groupName, Boolean.TRUE);
        this.basicCache.addUserToGroup(userName, groupName);
        this.basicCache.addGroupToUser(userName, groupName);
    }

    @Override
    public void removeMembership(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, MembershipNotFoundException, UserNotFoundException, InvalidAuthenticationException, GroupNotFoundException {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)groupName);
        this.server.removeMembership(userName, groupName);
        this.basicCache.setMembership(userName, groupName, Boolean.FALSE);
        this.basicCache.removeUserFromGroup(userName, groupName);
        this.basicCache.removeGroupFromUser(userName, groupName);
    }

    @Override
    public List getMemberships(String userName) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, UserNotFoundException {
        Preconditions.checkNotNull((Object)userName);
        List<String> groupNames = this.basicCache.getAllMemberships(userName);
        if (groupNames == null) {
            List<String> directGroups = this.server.getMemberships(userName);
            groupNames = CollectionUtils.isEmpty(directGroups) ? directGroups : NestingHelper.getAllGroupsForUser(directGroups, this.getAncestorsForGroups());
            this.basicCache.cacheAllMemberships(userName, groupNames);
        }
        if (groupNames != null) {
            groupNames = this.getCorrectGroupNames(groupNames);
        }
        if (groupNames == null || groupNames.size() == 0) {
            return new ArrayList(1);
        }
        Collections.sort(groupNames);
        return groupNames;
    }

    @Override
    public List getMembers(String groupName) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, GroupNotFoundException {
        SOAPGroup group;
        Preconditions.checkNotNull((Object)groupName);
        List users = this.basicCache.getAllMembers(groupName);
        if (users == null && (group = this.basicCache.getGroup(groupName)) == null) {
            group = this.server.getGroup(groupName);
            users = this.basicCache.setMembers(groupName, group.getMembers());
            this.basicCache.cacheGroup(group);
        }
        if (users != null) {
            users = this.getCorrectUserNames(users);
        }
        if (users == null) {
            users = new ArrayList<String>(1);
        }
        return users;
    }

    public Boolean isUserOrGroup(String name) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        Preconditions.checkNotNull((Object)name);
        Boolean isUserOrGroup = this.basicCache.isUserOrGroup(name);
        if (isUserOrGroup == null) {
            if (this.groupManager.isGroup(name) || this.userManager.isUser(name)) {
                isUserOrGroup = Boolean.TRUE;
                this.basicCache.addIsUserOrGroup(name, Boolean.TRUE);
            } else {
                isUserOrGroup = Boolean.FALSE;
                this.basicCache.addIsUserOrGroup(name, Boolean.FALSE);
            }
        }
        return isUserOrGroup;
    }

    private Map<String, Set<String>> getAncestorsForGroups() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        Map<String, Set<String>> ancestorsByGroup = this.basicCache.getAncestorsForGroups();
        if (ancestorsByGroup == null) {
            this.groupManager.getAllGroupNames();
            ancestorsByGroup = this.basicCache.getAncestorsForGroups();
        }
        return ancestorsByGroup;
    }

    private List<String> getCorrectUserNames(List<String> names) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        ArrayList<String> correctNames = new ArrayList<String>(names.size());
        for (String name : names) {
            try {
                correctNames.add(this.getCorrectUserName(name));
            }
            catch (UserNotFoundException userNotFoundException) {}
        }
        return correctNames;
    }

    private List<String> getCorrectGroupNames(List<String> names) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        ArrayList<String> correctNames = new ArrayList<String>(names.size());
        for (String name : names) {
            try {
                correctNames.add(this.getCorrectGroupName(name));
            }
            catch (GroupNotFoundException groupNotFoundException) {}
        }
        return correctNames;
    }

    private String getCorrectUserName(String name) throws InvalidAuthorizationTokenException, RemoteException, UserNotFoundException, InvalidAuthenticationException {
        String correctName = this.basicCache.getUserName(name);
        if (correctName == null) {
            SOAPPrincipal principal = this.userManager.getUser(name);
            correctName = principal.getName();
        }
        return correctName;
    }

    private String getCorrectGroupName(String name) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException, GroupNotFoundException {
        String correctName = this.basicCache.getGroupName(name);
        if (correctName == null) {
            SOAPGroup group = this.groupManager.getGroup(name);
            correctName = group.getName();
        }
        return correctName;
    }

    private static class Server {
        private final SecurityServerClient securityServerClient;

        private Server(SecurityServerClient securityServerClient) {
            this.securityServerClient = securityServerClient;
        }

        public boolean isMember(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
            return this.securityServerClient.isGroupMember(groupName, userName);
        }

        public void addMembership(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, UserNotFoundException, InvalidAuthenticationException, GroupNotFoundException {
            this.securityServerClient.addPrincipalToGroup(userName, groupName);
        }

        public void removeMembership(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, MembershipNotFoundException, UserNotFoundException, InvalidAuthenticationException, GroupNotFoundException {
            this.securityServerClient.removePrincipalFromGroup(userName, groupName);
        }

        public List<String> getMemberships(String userName) throws RemoteException, InvalidAuthorizationTokenException, UserNotFoundException, InvalidAuthenticationException {
            String[] groupNames = this.securityServerClient.findGroupMemberships(userName);
            return Arrays.asList(groupNames);
        }

        public SOAPGroup getGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, GroupNotFoundException {
            return this.securityServerClient.findGroupByName(groupName);
        }
    }
}

