/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.cache;

import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.AuthenticationManager;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.util.Assert;
import java.rmi.RemoteException;

public class CacheAwareAuthenticationManager
implements AuthenticationManager {
    private final SecurityServerClient securityServerClient;
    private final UserManager crowdUserManager;

    public CacheAwareAuthenticationManager(SecurityServerClient securityServerClient, UserManager crowdUserManager) {
        this.securityServerClient = securityServerClient;
        this.crowdUserManager = crowdUserManager;
    }

    @Override
    public String authenticate(UserAuthenticationContext authenticationContext) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        Assert.notNull((Object)authenticationContext);
        if (authenticationContext.getApplication() == null) {
            authenticationContext.setApplication(this.getSecurityServerClient().getSoapClientProperties().getApplicationName());
        }
        String token = this.getSecurityServerClient().authenticatePrincipal(authenticationContext);
        this.ensureUserExistsInCache(authenticationContext.getName());
        return token;
    }

    @Override
    public String authenticateWithoutValidatingPassword(UserAuthenticationContext authenticationContext) throws ApplicationAccessDeniedException, InvalidAuthenticationException, InvalidAuthorizationTokenException, InactiveAccountException, RemoteException {
        Assert.notNull((Object)authenticationContext);
        String token = this.getSecurityServerClient().createPrincipalToken(authenticationContext.getName(), authenticationContext.getValidationFactors());
        this.ensureUserExistsInCache(authenticationContext.getName());
        return token;
    }

    @Override
    public String authenticate(String username, String password) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        Assert.notNull((Object)username);
        Assert.notNull((Object)password);
        String token = this.getSecurityServerClient().authenticatePrincipalSimple(username, password);
        this.ensureUserExistsInCache(username);
        return token;
    }

    @Override
    public boolean isAuthenticated(String token, ValidationFactor[] validationFactors) throws RemoteException, InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException {
        Assert.notNull((Object)token);
        return this.getSecurityServerClient().isValidToken(token, validationFactors);
    }

    @Override
    public void invalidate(String token) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        Assert.notNull((Object)token);
        this.getSecurityServerClient().invalidateToken(token);
    }

    @Override
    public SecurityServerClient getSecurityServerClient() {
        return this.securityServerClient;
    }

    private void ensureUserExistsInCache(String name) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        try {
            this.crowdUserManager.getUser(name);
        }
        catch (UserNotFoundException e) {
            throw InvalidAuthenticationException.newInstanceWithName((String)name);
        }
    }
}

