/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.service.cache.BasicCache;
import com.atlassian.crowd.util.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestingHelper {
    private static final Logger logger = Logger.getLogger(NestingHelper.class);

    public static List<String> cacheGroupRelationships(SOAPNestableGroup[] allGroups, BasicCache cache) {
        Assert.notNull((Object)allGroups);
        ArrayList<String> allGroupNames = new ArrayList<String>(allGroups.length);
        for (SOAPNestableGroup group : allGroups) {
            allGroupNames.add(group.getName());
        }
        cache.cacheAllGroupNames(allGroupNames);
        NestingHelper.cacheAncestors(allGroups, cache);
        return allGroupNames;
    }

    private static void cacheAncestors(SOAPNestableGroup[] allGroups, BasicCache cache) {
        HashMap<String, Set<String>> ancestorsByGroup = new HashMap<String, Set<String>>(allGroups.length);
        Map<String, Set<String>> parentsByGroup = NestingHelper.getParentsByGroup(allGroups);
        for (SOAPNestableGroup group : allGroups) {
            String groupName = group.getName();
            HashSet<String> ancestors = new HashSet<String>();
            NestingHelper.addAncestors(parentsByGroup, groupName, ancestors, groupName);
            ancestors.remove(groupName);
            ancestorsByGroup.put(groupName, ancestors);
        }
        cache.cacheAncestorsForGroups(ancestorsByGroup);
    }

    private static Map<String, Set<String>> getParentsByGroup(SOAPNestableGroup[] allGroups) {
        HashMap<String, Set<String>> parentsByGroup = new HashMap<String, Set<String>>(allGroups.length);
        for (SOAPNestableGroup group : allGroups) {
            parentsByGroup.put(group.getName(), new HashSet());
        }
        for (SOAPNestableGroup parentGroup : allGroups) {
            if (parentGroup.getGroupMembers() == null) continue;
            for (String groupName : parentGroup.getGroupMembers()) {
                ((Set)parentsByGroup.get(groupName)).add(parentGroup.getName());
            }
        }
        return parentsByGroup;
    }

    private static void addAncestors(Map<String, Set<String>> parentsByGroup, String group, Set<String> ancestors, String ancestorGroup) {
        Set<String> parents = parentsByGroup.get(ancestorGroup);
        for (String parent : parents) {
            if (ancestors.contains(parent) || group.equals(parent)) continue;
            ancestors.add(parent);
            NestingHelper.addAncestors(parentsByGroup, group, ancestors, parent);
        }
    }

    public static List<String> getAllGroupsForUser(List<String> directGroups, Map<String, Set<String>> ancestorsByGroup) {
        Assert.notNull(directGroups);
        HashSet<String> allGroups = new HashSet<String>(directGroups);
        for (String directGroup : directGroups) {
            Set<String> ancestors = ancestorsByGroup.get(directGroup);
            if (ancestors != null) {
                allGroups.addAll(ancestors);
                continue;
            }
            logger.warn((Object)("Could not find group ancestor information for group '" + directGroup + "' in cache."));
        }
        return new ArrayList<String>(allGroups);
    }
}

