package com.atlassian.crowd.integration.rest.service;

import com.atlassian.crowd.service.client.AuthenticationMethod;
import com.atlassian.crowd.service.client.ClientProperties;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

public class BasicAuthRestExecutor extends RestExecutor {
    /**
     * Constructs a new REST Crowd client executor instance.
     *
     * @param clientProperties connection parameters
     */
    public static BasicAuthRestExecutor createFrom(ClientProperties clientProperties, CloseableHttpClient httpClient) {
        checkArgument(clientProperties.getAuthenticationMethod() == AuthenticationMethod.BASIC_AUTH,
                "Client properties should specify Basic auth as the authentication method");
        String baseUrl = createBaseUrl(clientProperties.getBaseURL());
        HttpHost httpHost = createHttpHost(clientProperties);
        CredentialsProvider credsProvider = createBasicAuthCredentialsProvider(clientProperties, httpHost);
        return new BasicAuthRestExecutor(baseUrl, httpHost, credsProvider, httpClient);
    }

    private static CredentialsProvider createBasicAuthCredentialsProvider(ClientProperties clientProperties, HttpHost httpHost) {
        CredentialsProvider credsProvider = createCredentialsProvider(clientProperties);

        checkNotNull(clientProperties.getApplicationName(), "Missing required Crowd client application name");
        checkNotNull(clientProperties.getApplicationPassword(), "Missing required Crowd client application password");
        credsProvider.setCredentials(
                new AuthScope(httpHost),
                new UsernamePasswordCredentials(clientProperties.getApplicationName(), clientProperties.getApplicationPassword()));

        return credsProvider;
    }

    BasicAuthRestExecutor(String baseUrl, HttpHost httpHost, CredentialsProvider credsProvider, CloseableHttpClient client) {
        super(baseUrl, httpHost, credsProvider, client);
    }

}
