/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.rest.service;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCrowdServiceException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.rest.entity.ErrorEntity;
import com.atlassian.crowd.integration.rest.service.CrowdRestException;
import com.atlassian.crowd.integration.rest.service.util.ShutdownIgnoringMultiThreadedHttpConnectionManager;
import com.atlassian.crowd.integration.rest.util.JAXBContextCache;
import com.atlassian.crowd.service.client.ClientProperties;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestExecutor {
    private static final String INVALID_REST_SERVICE_MSG_FORMAT = "The following URL does not specify a valid Crowd User Management REST service: %s";
    private static final String EMBEDDED_CROWD_VERSION_NAME = "X-Embedded-Crowd-Version";
    private static final Logger logger = LoggerFactory.getLogger(RestExecutor.class);
    private static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 20;
    private final ShutdownIgnoringMultiThreadedHttpConnectionManager connectionManager = new ShutdownIgnoringMultiThreadedHttpConnectionManager();
    private final String baseUrl;
    private final HttpHost httpHost;
    private final CredentialsProvider credsProvider;
    private final HttpClient client;
    private final JAXBContextCache jaxbContexts = new JAXBContextCache();
    private static final ContentType APPLICATION_XML = ContentType.create((String)"application/xml", (Charset)Charsets.UTF_8);
    private static final Pattern HTML_CONTENT_TYPE = Pattern.compile("text/html(\\s*;.*)?", 2);
    private static final Pattern UP_TO_HTML_BODY = Pattern.compile(".*<body[^>]*>", 32);

    RestExecutor(ClientProperties clientProperties) {
        try {
            URI uri = new URI(clientProperties.getBaseURL());
            this.baseUrl = RestExecutor.createBaseUrl(clientProperties.getBaseURL());
            this.httpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(10).setMaxObjectSize(16384L).setHeuristicCachingEnabled(false).setSharedCache(false).setAsynchronousWorkersMax(0).build();
            this.credsProvider = new BasicCredentialsProvider();
            this.credsProvider.setCredentials(new AuthScope(this.httpHost), (Credentials)new UsernamePasswordCredentials(clientProperties.getApplicationName(), clientProperties.getApplicationPassword()));
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            this.setRequestConfig(requestConfigBuilder, clientProperties);
            RequestConfig requestConfig = requestConfigBuilder.build();
            this.client = CachingHttpClients.custom().setCacheConfig(cacheConfig).setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void setRequestConfig(RequestConfig.Builder builder, ClientProperties clientProperties) {
        builder.setConnectTimeout(NumberUtils.toInt((String)clientProperties.getHttpTimeout(), (int)5000));
        builder.setSocketTimeout(NumberUtils.toInt((String)clientProperties.getSocketTimeout(), (int)600000));
        this.connectionManager.setMaxTotal(NumberUtils.toInt((String)clientProperties.getHttpMaxConnections(), (int)20));
        HttpRoute httpRoute = new HttpRoute(this.httpHost);
        this.connectionManager.setMaxPerRoute(httpRoute, NumberUtils.toInt((String)clientProperties.getHttpMaxConnections(), (int)this.connectionManager.getMaxTotal()));
        this.initProxyConfiguration(clientProperties, builder);
    }

    public RestExecutor(String baseUrl, HttpHost httpHost, CredentialsProvider credsProvider, HttpClient client) {
        this.baseUrl = baseUrl;
        this.httpHost = httpHost;
        this.credsProvider = credsProvider;
        this.client = client;
    }

    private HttpCacheContext contextForThisThread() {
        HttpCacheContext context = HttpCacheContext.create();
        context.setCredentialsProvider(this.credsProvider);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.httpHost, (AuthScheme)basicAuth);
        context.setAuthCache((AuthCache)authCache);
        return context;
    }

    private void initProxyConfiguration(ClientProperties clientProperties, RequestConfig.Builder builder) {
        if (clientProperties.getHttpProxyHost() != null) {
            HttpHost proxy = new HttpHost(clientProperties.getHttpProxyHost(), NumberUtils.toInt((String)clientProperties.getHttpProxyPort(), (int)-1));
            builder.setProxy(proxy);
            if (clientProperties.getHttpProxyUsername() != null && clientProperties.getHttpProxyPassword() != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(clientProperties.getHttpProxyUsername(), clientProperties.getHttpProxyPassword());
                this.credsProvider.setCredentials(new AuthScope(proxy), (Credentials)credentials);
            }
        }
    }

    private static String createBaseUrl(String url) {
        StringBuilder sb = new StringBuilder(url);
        if (url.endsWith("/")) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("/rest/usermanagement/1");
        return sb.toString();
    }

    MethodExecutor get(String format, Object ... args) {
        return new MethodExecutor((HttpUriRequest)new HttpGet(RestExecutor.buildUrl(this.baseUrl, format, args)));
    }

    MethodExecutor delete(String format, Object ... args) {
        return new MethodExecutor((HttpUriRequest)new HttpDelete(RestExecutor.buildUrl(this.baseUrl, format, args)));
    }

    MethodExecutor postEmpty(String format, Object ... args) {
        HttpPost method = new HttpPost(RestExecutor.buildUrl(this.baseUrl, format, args));
        method.setEntity((HttpEntity)new StringEntity("", APPLICATION_XML));
        return new MethodExecutor((HttpUriRequest)method);
    }

    MethodExecutor post(Object body, String format, Object ... args) {
        HttpPost method = new HttpPost(RestExecutor.buildUrl(this.baseUrl, format, args));
        this.setBody((HttpEntityEnclosingRequestBase)method, body);
        return new MethodExecutor((HttpUriRequest)method);
    }

    MethodExecutor put(Object body, String format, Object ... args) {
        HttpPut method = new HttpPut(RestExecutor.buildUrl(this.baseUrl, format, args));
        this.setBody((HttpEntityEnclosingRequestBase)method, body);
        return new MethodExecutor((HttpUriRequest)method);
    }

    private void setBody(HttpEntityEnclosingRequestBase method, Object body) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            this.getMarshaller(body.getClass()).marshal(body, (OutputStream)bs);
        }
        catch (JAXBException e) {
            throw new DataBindingException("Cannot marshall object " + body, (Throwable)e);
        }
        method.setEntity((HttpEntity)new ByteArrayEntity(bs.toByteArray(), APPLICATION_XML));
    }

    static String buildUrl(String baseUrl, String format, Object ... args) {
        Object[] encodedArgs = new Object[args.length];
        int pathArgCount = RestExecutor.pathArgumentCount(format);
        try {
            int i;
            for (i = 0; i < pathArgCount; ++i) {
                encodedArgs[i] = args[i] instanceof String ? URLEncoder.encode((String)args[i], "utf-8").replace("+", "%20") : args[i];
            }
            for (i = pathArgCount; i < args.length; ++i) {
                encodedArgs[i] = args[i] instanceof String ? URLEncoder.encode((String)args[i], "utf-8") : args[i];
            }
            String url = baseUrl + String.format(format, encodedArgs);
            logger.debug("Constructed " + url);
            return url;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static int pathArgumentCount(String format) {
        int queryStart = format.indexOf(63);
        if (queryStart == -1) {
            queryStart = format.length();
        }
        int count = 0;
        int i = format.indexOf(37);
        while (i != -1 && i < queryStart) {
            ++count;
            i = format.indexOf(37, i + 1);
        }
        return count;
    }

    void shutDown() {
        this.connectionManager.reallyShutdown();
    }

    private Marshaller getMarshaller(Class<?> clazz) {
        try {
            return this.jaxbContexts.getJAXBContext(clazz).createMarshaller();
        }
        catch (JAXBException e) {
            throw new DataBindingException("Cannot create marshaller for class " + clazz, (Throwable)e);
        }
    }

    private Unmarshaller getUnmarshaller(Class<?> clazz) {
        try {
            return this.jaxbContexts.getJAXBContext(clazz).createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new DataBindingException("Cannot create unmarshaller for class " + clazz, (Throwable)e);
        }
    }

    static String getExceptionMessageFromResponse(HttpResponse method) throws IOException {
        Header h = method.getFirstHeader("Content-Type");
        if (h != null && HTML_CONTENT_TYPE.matcher(h.getValue()).matches()) {
            return RestExecutor.stripHtml(EntityUtils.toString((HttpEntity)method.getEntity()));
        }
        return EntityUtils.toString((HttpEntity)method.getEntity());
    }

    static String stripHtml(String s) {
        String onlyTheBody = UP_TO_HTML_BODY.matcher(s).replaceAll("");
        String withoutTags = onlyTheBody.replaceAll("<[^>]*>", "");
        return StringUtils.normalizeSpace((String)StringEscapeUtils.unescapeHtml4((String)withoutTags));
    }

    class MethodExecutor {
        final HttpUriRequest method;
        final Set<Integer> statusCodesWithoutErrorEntity;
        protected HttpResponse response;

        MethodExecutor(HttpUriRequest method) {
            this(method, (Set<Integer>)ImmutableSet.of());
        }

        MethodExecutor(HttpUriRequest method, Set<Integer> statusCodesWithoutErrorEntity) {
            this.method = method;
            this.statusCodesWithoutErrorEntity = statusCodesWithoutErrorEntity;
        }

        public MethodExecutor ignoreErrorEntityForStatusCode(int statusCode) {
            ImmutableSet newStatusCodesWithoutErrorEntity = ImmutableSet.builder().addAll(this.statusCodesWithoutErrorEntity).add((Object)statusCode).build();
            return new MethodExecutor(this.method, (Set<Integer>)newStatusCodesWithoutErrorEntity);
        }

        <T> T andReceive(Class<T> returnType) throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, CrowdRestException {
            this.method.setHeader("Accept", "application/xml");
            try {
                int statusCode = this.executeCrowdServiceMethod(this.method);
                if (!this.isSuccess(statusCode)) {
                    this.throwError(statusCode);
                    throw new OperationFailedException(this.response.getStatusLine().getReasonPhrase());
                }
                Object object = RestExecutor.this.getUnmarshaller(returnType).unmarshal((Source)new StreamSource(this.response.getEntity().getContent()), returnType).getValue();
                return (T)object;
            }
            catch (IOException e) {
                throw new OperationFailedException((Throwable)e);
            }
            catch (JAXBException e) {
                throw new OperationFailedException((Throwable)e);
            }
            finally {
                if (this.response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
                }
            }
        }

        boolean doesExist() throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, CrowdRestException {
            try {
                int statusCode = this.executeCrowdServiceMethod(this.method);
                EntityUtils.consume((HttpEntity)this.response.getEntity());
                if (this.isSuccess(statusCode)) {
                    return true;
                }
                if (statusCode == 404) {
                    return false;
                }
                this.throwError(statusCode);
                throw new OperationFailedException(this.response.getStatusLine().getReasonPhrase());
            }
            catch (IOException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }

        void andCheckResponse() throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, CrowdRestException {
            this.method.setHeader("Accept", "application/xml");
            try {
                int statusCode = this.executeCrowdServiceMethod(this.method);
                if (!this.isSuccess(statusCode)) {
                    this.throwError(statusCode);
                    throw new OperationFailedException(this.response.getStatusLine().getReasonPhrase());
                }
            }
            catch (IOException e) {
                throw new OperationFailedException((Throwable)e);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
            }
        }

        private boolean isSuccess(int statusCode) {
            return statusCode >= 200 && statusCode < 300;
        }

        int executeCrowdServiceMethod(HttpUriRequest method) throws InvalidCrowdServiceException, IOException {
            HttpCacheContext context = RestExecutor.this.contextForThisThread();
            this.response = RestExecutor.this.client.execute(method, (HttpContext)context);
            logger.debug("Cache response for {} {} was {}", new Object[]{method.getMethod(), method.getURI(), context.getCacheResponseStatus()});
            if (!this.isCrowdRestService(this.response)) {
                EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
                throw new InvalidCrowdServiceException(String.format(RestExecutor.INVALID_REST_SERVICE_MSG_FORMAT, method.getURI().toString()));
            }
            return this.response.getStatusLine().getStatusCode();
        }

        private boolean isCrowdRestService(HttpResponse method) {
            return method.containsHeader(RestExecutor.EMBEDDED_CROWD_VERSION_NAME);
        }

        void throwError(int errorCode) throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, CrowdRestException {
            try {
                if (errorCode == 403) {
                    throw new ApplicationPermissionException(RestExecutor.getExceptionMessageFromResponse(this.response));
                }
                if (errorCode == 401) {
                    throw new InvalidAuthenticationException(RestExecutor.getExceptionMessageFromResponse(this.response));
                }
                if (errorCode >= 300) {
                    if (this.statusCodesWithoutErrorEntity.contains(errorCode)) {
                        throw new CrowdRestException("HTTP error: " + errorCode + " " + this.response.getStatusLine().getReasonPhrase() + ". Response body: " + EntityUtils.toString((HttpEntity)this.response.getEntity()), null, errorCode);
                    }
                    ErrorEntity errorEntity = (ErrorEntity)RestExecutor.this.getUnmarshaller(ErrorEntity.class).unmarshal((Source)new StreamSource(this.response.getEntity().getContent()), ErrorEntity.class).getValue();
                    throw new CrowdRestException(errorEntity.getMessage(), errorEntity, errorCode);
                }
            }
            catch (IOException e) {
                throw new OperationFailedException(this.response.getStatusLine().getReasonPhrase());
            }
            catch (DataBindingException dbe) {
                throw new OperationFailedException(this.response.getStatusLine().getReasonPhrase(), (Throwable)dbe);
            }
            catch (JAXBException e) {
                throw new OperationFailedException(this.response.getStatusLine().getReasonPhrase());
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
            }
        }
    }
}

