/*
 * Copyright (c) 2006 Atlassian Software Systems. All Rights Reserved.
 */
package com.atlassian.crowd.model.authentication;

import com.atlassian.crowd.embedded.api.PasswordCredential;

/**
 * The <code>ApplicationAuthenticationContext</code> is used by authenticating
 * {@link com.atlassian.crowd.model.application.Application applications}.
 */
public class ApplicationAuthenticationContext extends AuthenticationContext {
    public ApplicationAuthenticationContext() {
    }

    public ApplicationAuthenticationContext(String name, PasswordCredential credential, ValidationFactor[] validationFactors) {
        super(name, credential, validationFactors);
    }

    public ApplicationAuthenticationContext(AuthenticationContext authenticationContext) {
        super(authenticationContext.getName(), authenticationContext.getCredential(), authenticationContext.getValidationFactors());
    }
}