/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.http;

import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.CrowdClient;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class CrowdHttpAuthenticatorImpl
implements CrowdHttpAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(CrowdHttpAuthenticator.class);
    private final CrowdClient client;
    private final ClientProperties clientProperties;
    private final CrowdHttpTokenHelper tokenHelper;

    public CrowdHttpAuthenticatorImpl(CrowdClient client, ClientProperties clientProperties, CrowdHttpTokenHelper tokenHelper) {
        this.client = client;
        this.clientProperties = clientProperties;
        this.tokenHelper = tokenHelper;
    }

    public User getUser(HttpServletRequest request) throws InvalidTokenException, ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException {
        String ssoToken = this.tokenHelper.getCrowdToken(request, this.getCookieTokenKey());
        if (ssoToken != null) {
            return this.client.findUserFromSSOToken(ssoToken);
        }
        LOGGER.debug((Object)"Could not find user from token.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User authenticate(HttpServletRequest request, HttpServletResponse response, String username, String password) throws InvalidTokenException, ApplicationAccessDeniedException, ExpiredCredentialException, InactiveAccountException, ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException {
        UserAuthenticationContext userAuthenticationContext = this.tokenHelper.getUserAuthenticationContext(request, username, password, this.clientProperties);
        CookieConfiguration cookieConfig = this.client.getCookieConfiguration();
        String ssoToken = null;
        try {
            ssoToken = this.client.authenticateSSOUser(userAuthenticationContext);
            this.tokenHelper.setCrowdToken(request, response, ssoToken, this.clientProperties, cookieConfig);
        }
        finally {
            if (ssoToken == null) {
                this.tokenHelper.removeCrowdToken(request, response, this.clientProperties, cookieConfig);
            }
        }
        return this.client.findUserFromSSOToken(ssoToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User authenticateWithoutValidatingPassword(HttpServletRequest request, HttpServletResponse response, String username) throws InvalidTokenException, ApplicationAccessDeniedException, InactiveAccountException, ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException {
        UserAuthenticationContext userAuthenticationContext = this.tokenHelper.getUserAuthenticationContext(request, username, null, this.clientProperties);
        CookieConfiguration cookieConfig = this.client.getCookieConfiguration();
        String ssoToken = null;
        try {
            ssoToken = this.client.authenticateSSOUserWithoutValidatingPassword(userAuthenticationContext);
            this.tokenHelper.setCrowdToken(request, response, ssoToken, this.clientProperties, cookieConfig);
        }
        finally {
            if (ssoToken == null) {
                this.tokenHelper.removeCrowdToken(request, response, this.clientProperties, cookieConfig);
            }
        }
        return this.client.findUserFromSSOToken(ssoToken);
    }

    public boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) throws OperationFailedException {
        long timeSpread;
        HttpSession session = request.getSession();
        String token = this.tokenHelper.getCrowdToken(request, this.clientProperties.getCookieTokenKey());
        if (token == null) {
            LOGGER.debug((Object)"Non authenticated request, unable to find a valid Crowd token.");
            return false;
        }
        Date lastValidation = (Date)session.getAttribute(this.clientProperties.getSessionLastValidation());
        if (lastValidation != null && this.clientProperties.getSessionValidationInterval() > 0L && (timeSpread = lastValidation.getTime() + 60000L * this.clientProperties.getSessionValidationInterval()) > System.currentTimeMillis()) {
            return true;
        }
        try {
            this.client.validateSSOAuthentication(token, this.tokenHelper.getValidationFactorExtractor().getValidationFactors(request));
            CookieConfiguration cookieConfig = this.client.getCookieConfiguration();
            this.tokenHelper.setCrowdToken(request, response, token, this.clientProperties, cookieConfig);
            return true;
        }
        catch (ApplicationPermissionException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
            return false;
        }
        catch (InvalidAuthenticationException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
            return false;
        }
        catch (InvalidTokenException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException {
        String ssoToken = this.tokenHelper.getCrowdToken(request, this.getCookieTokenKey());
        if (ssoToken != null) {
            this.client.invalidateSSOToken(ssoToken);
        }
        CookieConfiguration cookieConfig = this.client.getCookieConfiguration();
        this.tokenHelper.removeCrowdToken(request, response, this.clientProperties, cookieConfig);
    }

    public String getToken(HttpServletRequest request) {
        return this.tokenHelper.getCrowdToken(request, this.getCookieTokenKey());
    }

    private String getCookieTokenKey() {
        return this.clientProperties.getCookieTokenKey();
    }
}

