package com.atlassian.crowd.model.event;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class UserMembershipEvent extends AbstractOperationEvent {
    private final String childUsername;
    private final Set<String> parentGroupNames;

    public UserMembershipEvent(Operation operation, Long directoryId, String childUsername, String groupName) {
        super(operation, directoryId);
        this.childUsername = childUsername;
        this.parentGroupNames = Collections.singleton(groupName);
    }

    public UserMembershipEvent(Operation operation, Long directoryId, String childUsername, Set<String> parentGroupNames) {
        super(operation, directoryId);
        this.childUsername = childUsername;
        this.parentGroupNames = parentGroupNames;
    }

    public Set<String> getParentGroupNames() {
        return parentGroupNames;
    }

    public String getChildUsername() {
        return childUsername;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        UserMembershipEvent that = (UserMembershipEvent) o;
        return Objects.equals(childUsername, that.childUsername) &&
                Objects.equals(parentGroupNames, that.parentGroupNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), childUsername, parentGroupNames);
    }

    @Override
    public String toString() {
        return "UserMembershipEvent{" +
                "operation=" + getOperation() +
                ",directory=" + getDirectoryId() +
                ",childUsername='" + childUsername + '\'' +
                ", parentGroupNames=" + parentGroupNames +
                '}';
    }
}
