package com.atlassian.crowd.model.event;

import java.util.Map;
import java.util.Set;

import com.atlassian.crowd.model.group.Group;

import com.google.common.base.MoreObjects;

public class GroupEvent extends AbstractAttributeEvent {
    private final Group group;

    public GroupEvent(Operation operation, Long directoryId, Group group, Map<String, Set<String>> storedAttributes, Set<String> deletedAttributes) {
        super(operation, directoryId, storedAttributes, deletedAttributes);
        this.group = group;
    }

    public Group getGroup() {
        return group;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("operation", getOperation())
                .add("group", group == null ? null : group.getName())
                .add("directory", getDirectoryId())
                .toString();
    }
}
