package com.atlassian.crowd.audit;

/**
 * Determines the type of entity which was changed during the audit action
 */
public enum AuditLogEntityType {
    /**
     * Indicates a configuration change to an application, application creation or application deletion
     */
    APPLICATION,
    /**
     * Indicates a configuration change to a directory, directory creation or directory deletion
     */
    DIRECTORY,
    /**
     * Indicates creation, modification, or deletion of a user
     */
    USER,
    /**
     * Indicates creation, modification, or deletion of a group
     */
    GROUP,
    /**
     * Indicates a change to Crowd configuration
     */
    CONFIGURATION,
    /**
     * Indicates a restore of Crowd configuration from backup
     */
    RESTORE,
    /**
     * Indicates another type of change, ie made by a custom integration
     */
    OTHER,
}
