package com.atlassian.crowd.audit;

/**
 * Determines the type of entity that created the audit log entry
 */
public enum AuditLogAuthorType {
    /**
     * The audit action was performed by a Crowd user
     */
    USER,

    /**
     * The audit action was performed by an application authenticating to Crowd
     */
    APPLICATION,

    /**
     * The audit action was performed by Crowd, ie as consequence of another action
     */
    SYSTEM,

    /**
     * The audit action was performed by a plugin
     */
    PLUGIN,

    /**
     * The action was performed by a synchronization with a remote directory
     * @since 3.2.0
     */
    SYNCHRONIZATION,

    /**
     *  The action was performed by a data import from an external source.
     *  @since 3.2.0
     */
    DATA_IMPORT,

    /**
     * The audit action was performed by something other than the entities above, ie custom integration
     */
    OTHER
}
