/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.application;

import com.atlassian.ip.Subnet;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class RemoteAddress
implements Serializable,
Comparable<RemoteAddress> {
    private static final Logger log = Logger.getLogger(RemoteAddress.class);
    private String address;
    private String encodedAddressBytes;
    private int mask;

    private RemoteAddress() {
    }

    public RemoteAddress(String address) {
        Validate.notEmpty((String)address, (String)"You cannot create a remote address with null address");
        this.address = address;
        this.parseAddress();
    }

    private void parseAddress() {
        try {
            Subnet subnet = Subnet.forPattern((String)this.address);
            this.mask = RemoteAddress.isIPAddress(subnet) ? 0 : subnet.getMask();
            byte[] unchunkedEncodedByteArray = Base64.encodeBase64((byte[])subnet.getAddress(), (boolean)false);
            this.encodedAddressBytes = RemoteAddress.newStringUtf8(unchunkedEncodedByteArray);
        }
        catch (IllegalArgumentException e) {
            this.mask = 0;
            this.encodedAddressBytes = null;
        }
    }

    private static boolean isIPAddress(Subnet subnet) {
        return subnet.getMask() == subnet.getAddress().length * 8;
    }

    public String getAddress() {
        return this.address;
    }

    private void setAddress(String address) {
        this.address = address;
    }

    public byte[] getAddressBytes() {
        return Base64.decodeBase64((byte[])RemoteAddress.getBytesUtf8(this.encodedAddressBytes));
    }

    public boolean isHostName() {
        return this.encodedAddressBytes == null;
    }

    public int getMask() {
        return this.mask;
    }

    private void setMask(int mask) {
        this.mask = mask;
    }

    public String getEncodedAddressBytes() {
        return this.encodedAddressBytes;
    }

    private void setEncodedAddressBytes(String encodedAddressBytes) {
        this.encodedAddressBytes = encodedAddressBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteAddress that = (RemoteAddress)o;
        return !(this.address != null ? !this.address.equals(that.address) : that.address != null);
    }

    public int hashCode() {
        return this.address != null ? this.address.hashCode() : 0;
    }

    @Override
    public int compareTo(RemoteAddress o) {
        return this.address.compareTo(o.getAddress());
    }

    private static String newStringUtf8(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported", e);
        }
    }

    private static byte[] getBytesUtf8(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported", e);
        }
    }
}

