package com.atlassian.crowd.model.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.DirectoryEntities;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;

/**
 * Utility class for {@link User}
 *
 * @since v2.7
 */
public final class Users {
    /**
     * A function that projects the user name
     *
     * @deprecated Use the more general {@link DirectoryEntities#NAME_FUNCTION}.
     */
    public static final Function<User, String> NAME_FUNCTION = User::getName;

    /**
     * A function that projects the lower case user name
     *
     * @deprecated Use the more general {@link DirectoryEntities#LOWER_NAME_FUNCTION}.
     */
    public static final Function<User, String> LOWER_NAME_FUNCTION =
            Functions.compose(IdentifierUtils.TO_LOWER_CASE, NAME_FUNCTION);


    private Users() {
        // I'm a utility class. Please use my static methods, but don't instantiate me
    }

    /**
     * Transforms users into their names.
     *
     * @param users some users
     * @return their names
     * @deprecated Use the more general {@link DirectoryEntities#namesOf}.
     */
    public static Iterable<String> namesOf(Iterable<? extends User> users) {
        return Iterables.transform(users, NAME_FUNCTION);
    }
}
