package com.atlassian.crowd.model.group;

import java.util.Set;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;

public final class ImmutableMembership implements Membership {
    private final String groupName;
    private final Set<String> userNames;
    private final Set<String> childGroupNames;

    public ImmutableMembership(String groupName, Iterable<String> userNames, Iterable<String> childGroupNames) {
        this.groupName = Preconditions.checkNotNull(groupName);
        this.childGroupNames = ImmutableSet.copyOf(childGroupNames);
        this.userNames = ImmutableSet.copyOf(userNames);
    }

    @Override
    public String getGroupName() {
        return groupName;
    }

    @Override
    public Set<String> getUserNames() {
        return userNames;
    }

    @Override
    public Set<String> getChildGroupNames() {
        return childGroupNames;
    }
}
