package com.atlassian.crowd.model.application;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;

/**
 * Utility class for {@link Application}
 *
 * @since v2.7
 */
public final class Applications {
    /**
     * A function that projects the application name
     */
    public static final Function<Application, String> NAME_FUNCTION = Application::getName;

    /**
     * A predicate that checks if the application is active
     */
    public static final Predicate<Application> ACTIVE_FILTER = Application::isActive;

    private Applications() {
        // I'm a utility class. Please use my static methods, but don't instantiate me
    }

    /**
     * Transforms applications into their names.
     *
     * @param applications some applications
     * @return their names
     */
    public static Iterable<String> namesOf(Iterable<? extends Application> applications) {
        return Iterables.transform(applications, NAME_FUNCTION);
    }
}
