/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.authentication.UserAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.integration.exception.ExpiredCredentialException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.AuthenticationManager;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.util.Assert;
import java.rmi.RemoteException;

public class CacheAwareAuthenticationManager
implements AuthenticationManager {
    private final SecurityServerClient securityServerClient;
    private final UserManager crowdUserManager;

    public CacheAwareAuthenticationManager(SecurityServerClient securityServerClient, UserManager crowdUserManager) {
        this.securityServerClient = securityServerClient;
        this.crowdUserManager = crowdUserManager;
    }

    public String authenticate(UserAuthenticationContext authenticationContext) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        Assert.notNull(authenticationContext);
        if (authenticationContext.getApplication() == null) {
            authenticationContext.setApplication(this.getSecurityServerClient().getClientProperties().getApplicationName());
        }
        String token = this.getSecurityServerClient().authenticatePrincipal(authenticationContext);
        this.ensureUserExistsInCache(authenticationContext.getName());
        return token;
    }

    public String authenticateWithoutValidatingPassword(UserAuthenticationContext authenticationContext) throws ApplicationAccessDeniedException, InvalidAuthenticationException, InvalidAuthorizationTokenException, InactiveAccountException, RemoteException {
        Assert.notNull(authenticationContext);
        String token = this.getSecurityServerClient().createPrincipalToken(authenticationContext.getName(), authenticationContext.getValidationFactors());
        this.ensureUserExistsInCache(authenticationContext.getName());
        return token;
    }

    public String authenticate(String username, String password) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        Assert.notNull(username);
        Assert.notNull(password);
        String token = this.getSecurityServerClient().authenticatePrincipalSimple(username, password);
        this.ensureUserExistsInCache(username);
        return token;
    }

    public boolean isAuthenticated(String token, ValidationFactor[] validationFactors) throws RemoteException, InvalidAuthorizationTokenException, ApplicationAccessDeniedException {
        Assert.notNull(token);
        return this.getSecurityServerClient().isValidToken(token, validationFactors);
    }

    public void invalidate(String token) throws RemoteException, InvalidAuthorizationTokenException {
        Assert.notNull(token);
        this.getSecurityServerClient().invalidateToken(token);
    }

    public SecurityServerClient getSecurityServerClient() {
        return this.securityServerClient;
    }

    private void ensureUserExistsInCache(String name) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        try {
            this.crowdUserManager.getUser(name);
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidAuthenticationException(e);
        }
    }
}

