/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.group;

import com.atlassian.crowd.model.group.Membership;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class ImmutableMembership
implements Membership {
    private final String groupName;
    private final Set<String> userNames;
    private final Set<String> childGroupNames;

    public ImmutableMembership(String groupName, Iterable<String> userNames, Iterable<String> childGroupNames) {
        this.groupName = (String)Preconditions.checkNotNull((Object)groupName);
        this.childGroupNames = ImmutableSet.copyOf(childGroupNames);
        this.userNames = ImmutableSet.copyOf(userNames);
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public Set<String> getUserNames() {
        return this.userNames;
    }

    @Override
    public Set<String> getChildGroupNames() {
        return this.childGroupNames;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("groupName", (Object)this.groupName).append("userNames", this.userNames).append("childGroupNames", this.childGroupNames).toString();
    }
}

