/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.common.properties;

import java.time.Duration;

public class EncryptionProperties {
    public static final String ENCRYPTION_DURING_UPGRADE_DISABLED = "crowd.encryption.upgrade.disabled";
    public static final String ENRCYPTION_CACHE_ENABLED = "crowd.encryption.cache.enabled";
    public static final String ENCRYPTION_CACHE_MAX_SIZE = "crowd.encryption.cache.max.size";
    public static final String ENCRYPTION_CACHE_EXPIRE_MINUTES = "crowd.encryption.cache.expire.minutes";
    public static final String SET_ENCRYPTION_KEYS_OWNERSHIP_ATTRIBUTES = "crowd.encryption.keys.set.ownership.attributes";
    static final int ENCRYPTION_CACHE_MAX_SIZE_DEFAULT = 1000;
    static final int ENCRYPTION_CACHE_EXPIRE_MINUTES_DEFAULT = 10;

    private EncryptionProperties() {
    }

    public static Duration getEncryptionCacheExpiration() {
        return Duration.ofMinutes(Integer.getInteger(ENCRYPTION_CACHE_EXPIRE_MINUTES, 10).intValue());
    }

    public static int getEncryptionCacheMaxSize() {
        return Integer.getInteger(ENCRYPTION_CACHE_MAX_SIZE, 1000);
    }

    public static boolean isEncryptionCacheEnabled() {
        String enabled = System.getProperty(ENRCYPTION_CACHE_ENABLED);
        return enabled == null || Boolean.parseBoolean(enabled);
    }

    public static boolean isEncryptionDuringUpgradeDisabled() {
        return Boolean.parseBoolean(System.getProperty(ENCRYPTION_DURING_UPGRADE_DISABLED));
    }

    public static boolean isSetEncryptionKeysOwnershipAttributes() {
        return Boolean.getBoolean(SET_ENCRYPTION_KEYS_OWNERSHIP_ATTRIBUTES);
    }
}

