/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.cache;

import com.atlassian.crowd.directory.AzureAdDirectory;
import com.atlassian.crowd.directory.cache.DeltaQuerySyncTokenHolder;
import com.atlassian.crowd.directory.rest.mapper.DeltaQueryResult;
import com.atlassian.crowd.directory.rest.util.ThrowingMapMergeOperatorUtil;
import com.atlassian.crowd.directory.synchronisation.CacheSynchronisationResult;
import com.atlassian.crowd.directory.synchronisation.PartialSynchronisationResult;
import com.atlassian.crowd.directory.synchronisation.cache.CacheRefresher;
import com.atlassian.crowd.directory.synchronisation.cache.DirectoryCache;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributesAndMembershipChanges;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.util.EqualityUtil;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaQueryCacheRefresher
implements CacheRefresher {
    private final AzureAdDirectory azureAdDirectory;
    private Future<DeltaQueryResult<UserWithAttributes>> usersFuture;
    private Future<DeltaQueryResult<GroupTemplateWithAttributesAndMembershipChanges>> groupsFuture;
    private Map<String, String> userNamesToIds;
    private Map<String, String> groupNamesToIds;
    private Date syncStartDate;
    private static final Logger log = LoggerFactory.getLogger(DeltaQueryCacheRefresher.class);

    public DeltaQueryCacheRefresher(AzureAdDirectory remoteDirectory) {
        this.azureAdDirectory = remoteDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheSynchronisationResult synchroniseAll(DirectoryCache directoryCache) throws OperationFailedException {
        PartialSynchronisationResult<GroupTemplateWithAttributesAndMembershipChanges> allGroups;
        PartialSynchronisationResult<UserWithAttributes> allUsers;
        ExecutorService queryExecutor = Executors.newFixedThreadPool(2, ThreadFactories.namedThreadFactory((String)("DeltaQueryCacheRefresher-" + this.azureAdDirectory.getDirectoryId())));
        try {
            this.syncStartDate = new Date();
            this.usersFuture = queryExecutor.submit(this.azureAdDirectory::performUsersDeltaQuery);
            this.groupsFuture = queryExecutor.submit(this.azureAdDirectory::performGroupsDeltaQuery);
            this.userNamesToIds = new HashMap<String, String>();
            this.groupNamesToIds = new HashMap<String, String>();
            allUsers = this.synchroniseAllUsers(directoryCache);
            allGroups = this.synchroniseAllGroups(directoryCache);
            this.synchroniseAllMemberships(directoryCache, allUsers.getResults(), allGroups.getResults());
        }
        finally {
            queryExecutor.shutdown();
            this.clearState();
        }
        try {
            String syncToken = new ObjectMapper().writeValueAsString((Object)new DeltaQuerySyncTokenHolder((String)allUsers.getSyncToken().get(), (String)allGroups.getSyncToken().get()));
            return new CacheSynchronisationResult(true, syncToken);
        }
        catch (IOException e) {
            log.error("Error occured when serializing ");
            return new CacheSynchronisationResult(true, null);
        }
    }

    private void clearState() {
        this.usersFuture = null;
        this.groupsFuture = null;
        this.userNamesToIds = null;
        this.groupNamesToIds = null;
        this.syncStartDate = null;
    }

    public CacheSynchronisationResult synchroniseChanges(DirectoryCache directoryCache, @Nullable String syncToken) throws OperationFailedException {
        if (Strings.isNullOrEmpty((String)syncToken)) {
            log.info("Synchronisation token not present, full sync of directory [{}] is necessary before incremental sync is possible.", (Object)this.azureAdDirectory.getDirectoryId());
            return CacheSynchronisationResult.FAILURE;
        }
        DeltaQuerySyncTokenHolder deltaQueryTokens = this.deserializeDirectorySyncToken(syncToken);
        if (Strings.isNullOrEmpty((String)deltaQueryTokens.getGroupsDeltaQuerySyncToken())) {
            log.info("Groups delta token not present, falling back to full sync of directory [{}].", (Object)this.azureAdDirectory.getDirectoryId());
            return CacheSynchronisationResult.FAILURE;
        }
        if (Strings.isNullOrEmpty((String)deltaQueryTokens.getUsersDeltaQuerySyncToken())) {
            log.info("Users delta token not present, falling back to full sync of directory [{}].", (Object)this.azureAdDirectory.getDirectoryId());
            return CacheSynchronisationResult.FAILURE;
        }
        ExecutorService queryExecutor = Executors.newFixedThreadPool(2, ThreadFactories.namedThreadFactory((String)("DeltaQueryCacheRefresher-" + this.azureAdDirectory.getDirectoryId())));
        try {
            this.syncStartDate = new Date();
            this.usersFuture = queryExecutor.submit(() -> this.azureAdDirectory.fetchUserChanges(deltaQueryTokens.getUsersDeltaQuerySyncToken()));
            this.groupsFuture = queryExecutor.submit(() -> this.azureAdDirectory.fetchGroupChanges(deltaQueryTokens.getGroupsDeltaQuerySyncToken()));
            this.userNamesToIds = new HashMap<String, String>();
            this.groupNamesToIds = new HashMap<String, String>();
            DeltaQueryResult<UserWithAttributes> mappedUsers = this.synchroniseUserChanges(directoryCache, this.usersFuture.get());
            DeltaQueryResult<GroupTemplateWithAttributesAndMembershipChanges> mappedGroups = this.synchroniseGroupChanges(directoryCache, this.groupsFuture.get());
            this.synchroniseMembershipChanges(directoryCache, mappedUsers.getChangedEntities(), mappedGroups.getChangedEntities());
            CacheSynchronisationResult cacheSynchronisationResult = new CacheSynchronisationResult(true, this.serializeDirectorySyncToken(mappedUsers, mappedGroups));
            return cacheSynchronisationResult;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException("background query interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        finally {
            queryExecutor.shutdown();
            this.clearState();
        }
    }

    private String serializeDirectorySyncToken(DeltaQueryResult<UserWithAttributes> mappedUsers, DeltaQueryResult<GroupTemplateWithAttributesAndMembershipChanges> mappedGroups) {
        try {
            return new ObjectMapper().writeValueAsString((Object)new DeltaQuerySyncTokenHolder(mappedUsers.getSyncToken(), mappedGroups.getSyncToken()));
        }
        catch (IOException e) {
            log.warn("Cannot serialize synchronisation token obtained from Azure AD. Users sync token: '{}', groups sync token: '{}'", new Object[]{mappedUsers.getSyncToken(), mappedGroups.getSyncToken(), e});
            return null;
        }
    }

    private DeltaQuerySyncTokenHolder deserializeDirectorySyncToken(@Nullable String syncToken) {
        try {
            return (DeltaQuerySyncTokenHolder)new ObjectMapper().readValue(syncToken, DeltaQuerySyncTokenHolder.class);
        }
        catch (IOException e) {
            log.warn("Cannot perform incremental synchronisation for directory [{}] due to a malformed synchronisation token");
            throw new RuntimeException(e);
        }
    }

    private void synchroniseAllMemberships(DirectoryCache directoryCache, Collection<UserWithAttributes> mappedUsers, Collection<GroupTemplateWithAttributesAndMembershipChanges> mappedGroups) throws OperationFailedException {
        this.userNamesToIds.putAll(mappedUsers.stream().collect(Collectors.toMap(Principal::getName, User::getExternalId, ThrowingMapMergeOperatorUtil.throwingMerger())));
        this.groupNamesToIds.putAll(mappedGroups.stream().collect(Collectors.toMap(GroupTemplate::getName, GroupTemplate::getExternalId, ThrowingMapMergeOperatorUtil.duplicateMappedGroupsThrowingMerger(mappedGroups))));
        for (GroupTemplateWithAttributesAndMembershipChanges group : mappedGroups) {
            log.debug("Synchronising memberships for group {}", (Object)group.getName());
            if (this.azureAdDirectory.supportsNestedGroups()) {
                Set<String> groupChildrenFromRemoteDirectory = this.resolveGroupNamesForIdsAndPopulateIdsToNamesCache(group.getGroupChildrenIdsToAdd(), directoryCache, true);
                directoryCache.syncGroupMembersForGroup((Group)group, groupChildrenFromRemoteDirectory);
            }
            Set<String> userChildrenFromRemoteDirectory = this.resolveUserNamesForIdsAndPopulateIdsToNamesCache(group.getUserChildrenIdsToAdd(), directoryCache, true);
            directoryCache.syncUserMembersForGroup((Group)group, userChildrenFromRemoteDirectory);
        }
    }

    private void synchroniseMembershipChanges(DirectoryCache directoryCache, Collection<UserWithAttributes> mappedUsers, Collection<GroupTemplateWithAttributesAndMembershipChanges> mappedGroups) throws OperationFailedException {
        this.userNamesToIds.putAll(mappedUsers.stream().collect(Collectors.toMap(Principal::getName, User::getExternalId, ThrowingMapMergeOperatorUtil.throwingMerger())));
        this.groupNamesToIds.putAll(mappedGroups.stream().collect(Collectors.toMap(GroupTemplate::getName, GroupTemplate::getExternalId, ThrowingMapMergeOperatorUtil.duplicateMappedGroupsThrowingMerger(mappedGroups))));
        for (GroupTemplateWithAttributesAndMembershipChanges group : mappedGroups) {
            if (this.azureAdDirectory.supportsNestedGroups()) {
                Set<String> groupChildrenToAdd = this.resolveGroupNamesForIdsAndPopulateIdsToNamesCache(group.getGroupChildrenIdsToAdd(), directoryCache, true);
                directoryCache.addGroupMembersForGroup((Group)group, groupChildrenToAdd);
                Set<String> groupChildrenToRemove = this.resolveGroupNamesForIdsAndPopulateIdsToNamesCache(group.getGroupChildrenIdsToDelete(), directoryCache, false);
                directoryCache.deleteGroupMembersForGroup((Group)group, groupChildrenToRemove);
            }
            Set<String> userChildrenToAdd = this.resolveUserNamesForIdsAndPopulateIdsToNamesCache(group.getUserChildrenIdsToAdd(), directoryCache, true);
            directoryCache.addUserMembersForGroup((Group)group, userChildrenToAdd);
            Set<String> userChildrenToRemove = this.resolveUserNamesForIdsAndPopulateIdsToNamesCache(group.getUserChildrenIdsToDelete(), directoryCache, false);
            directoryCache.deleteUserMembersForGroup((Group)group, userChildrenToRemove);
        }
    }

    private Set<String> resolveUserNamesForIdsAndPopulateIdsToNamesCache(Set<String> idsToResolve, DirectoryCache directoryCache, boolean failOnNotResolved) throws OperationFailedException {
        Sets.SetView difference = Sets.difference(idsToResolve, (Set)ImmutableSet.copyOf(this.userNamesToIds.values()));
        if (!difference.isEmpty()) {
            log.debug("Azure AD reported memberships on users that were not modified: {}, trying to resolve them from directory cache", (Object)difference);
            Map foundUsers = directoryCache.findUsersByExternalIds((Set)difference);
            Sets.SetView usersNotFoundInCache = Sets.difference((Set)difference, foundUsers.keySet());
            if (failOnNotResolved && usersNotFoundInCache.size() > 0) {
                throw new OperationFailedException("Azure AD reported new memberships on users that were not returned during user sync. Users in question: " + usersNotFoundInCache);
            }
            foundUsers.forEach((externalId, name) -> this.userNamesToIds.put((String)name, (String)externalId));
        }
        return this.userNamesToIds.entrySet().stream().filter(entry -> idsToResolve.contains(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private Set<String> resolveGroupNamesForIdsAndPopulateIdsToNamesCache(Set<String> idsToResolve, DirectoryCache directoryCache, boolean failOnNotResolved) throws OperationFailedException {
        Sets.SetView difference = Sets.difference(idsToResolve, (Set)ImmutableSet.copyOf(this.groupNamesToIds.values()));
        if (!difference.isEmpty()) {
            log.debug("Azure AD reported memberships on groups that were not modified: {}, trying to resolve them from directory cache", (Object)difference);
            Map foundGroups = directoryCache.findGroupsByExternalIds((Set)difference);
            Sets.SetView groupsNotFoundInCache = Sets.difference((Set)difference, foundGroups.keySet());
            if (failOnNotResolved && groupsNotFoundInCache.size() > 0) {
                throw new OperationFailedException("Azure AD reported new memberships on groups that were not returned during group sync. Groups in question: " + groupsNotFoundInCache);
            }
            foundGroups.forEach((externalId, name) -> this.groupNamesToIds.put((String)name, (String)externalId));
        }
        return this.groupNamesToIds.entrySet().stream().filter(entry -> idsToResolve.contains(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private DeltaQueryResult<UserWithAttributes> synchroniseUserChanges(DirectoryCache directoryCache, DeltaQueryResult<UserWithAttributes> mappedUsers) throws OperationFailedException {
        this.handleNamelessEntities(mappedUsers, "users");
        directoryCache.deleteCachedUsersByGuid(mappedUsers.getDeletedEntities());
        directoryCache.addOrUpdateCachedUsers(mappedUsers.getChangedEntities(), this.syncStartDate);
        return mappedUsers;
    }

    private DeltaQueryResult<GroupTemplateWithAttributesAndMembershipChanges> synchroniseGroupChanges(DirectoryCache directoryCache, DeltaQueryResult<GroupTemplateWithAttributesAndMembershipChanges> mappedGroups) throws OperationFailedException {
        this.handleNamelessEntities(mappedGroups, "groups");
        this.checkNoRenamedGroups(directoryCache, mappedGroups);
        this.checkNoReaddedGroups(directoryCache, mappedGroups);
        directoryCache.deleteCachedGroupsByGuids(mappedGroups.getDeletedEntities());
        directoryCache.addOrUpdateCachedGroups(mappedGroups.getChangedEntities(), this.syncStartDate);
        return mappedGroups;
    }

    private void checkNoRenamedGroups(DirectoryCache directoryCache, DeltaQueryResult<GroupTemplateWithAttributesAndMembershipChanges> mappedGroups) throws OperationFailedException {
        Map<String, String> newEntitiesExternalIdsToNames = mappedGroups.getChangedEntities().stream().collect(Collectors.toMap(GroupTemplate::getExternalId, GroupTemplate::getName));
        Map externalIdsToNames = directoryCache.findGroupsByExternalIds(mappedGroups.getChangedEntities().stream().map(GroupTemplate::getExternalId).collect(Collectors.toSet()));
        Set differences = externalIdsToNames.entrySet().stream().filter(entry -> {
            String matchingChangedEntity = (String)newEntitiesExternalIdsToNames.get(entry.getKey());
            return matchingChangedEntity != null && EqualityUtil.different((String)matchingChangedEntity, (String)((String)entry.getValue()));
        }).collect(Collectors.toSet());
        if (!differences.isEmpty()) {
            log.info("Cannot proceed with incremental synchronisation due to groups with known external ids but unknownnames, falling back to full synchronisation. Groups in question: [{}]", differences);
            throw new OperationFailedException("Cannot proceed with incremental synchronisation due to renamed groups, falling back to full synchronisation.");
        }
    }

    private void checkNoReaddedGroups(DirectoryCache directoryCache, DeltaQueryResult<GroupTemplateWithAttributesAndMembershipChanges> mappedGroups) throws OperationFailedException {
        Map newEntitiesNamesToExternalIds = mappedGroups.getChangedEntities().stream().collect(Collectors.toMap(GroupTemplate::getName, GroupTemplate::getExternalId, ThrowingMapMergeOperatorUtil.duplicateMappedGroupsThrowingMerger(mappedGroups.getChangedEntities()), HashMap::new));
        Map namesToExternalIds = directoryCache.findGroupsExternalIdsByNames(mappedGroups.getChangedEntities().stream().map(GroupTemplate::getName).collect(Collectors.toSet()));
        Set differences = namesToExternalIds.entrySet().stream().filter(entry -> {
            String matchingChangedEntity = (String)newEntitiesNamesToExternalIds.get(entry.getKey());
            return matchingChangedEntity != null && EqualityUtil.different((String)matchingChangedEntity, (String)((String)entry.getValue())) && !mappedGroups.getDeletedEntities().contains(entry.getValue());
        }).collect(Collectors.toSet());
        if (!differences.isEmpty()) {
            log.info("Cannot proceed with incremental synchronisation due to groups readded with known names/duplicates, falling back to full synchronisation. Groups in question: [{}]", differences);
            throw new OperationFailedException("Cannot proceed with incremental synchronisation due to readded/duplicate groups, falling back to full synchronisation.");
        }
    }

    private PartialSynchronisationResult<UserWithAttributes> synchroniseAllUsers(DirectoryCache directoryCache) throws OperationFailedException {
        try {
            DeltaQueryResult<UserWithAttributes> mappedUsers = this.usersFuture.get();
            this.handleNamelessEntities(mappedUsers, "users");
            directoryCache.deleteCachedUsersNotIn(mappedUsers.getChangedEntities(), this.syncStartDate);
            directoryCache.addOrUpdateCachedUsers(mappedUsers.getChangedEntities(), this.syncStartDate);
            return new PartialSynchronisationResult(mappedUsers.getChangedEntities(), mappedUsers.getSyncToken());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException("background query interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private PartialSynchronisationResult<GroupTemplateWithAttributesAndMembershipChanges> synchroniseAllGroups(DirectoryCache directoryCache) throws OperationFailedException {
        try {
            DeltaQueryResult<GroupTemplateWithAttributesAndMembershipChanges> mappedGroups = this.groupsFuture.get();
            this.handleNamelessEntities(mappedGroups, "groups");
            directoryCache.deleteCachedGroupsNotInByExternalId(mappedGroups.getChangedEntities(), this.syncStartDate);
            directoryCache.addOrUpdateCachedGroups(mappedGroups.getChangedEntities(), this.syncStartDate);
            return new PartialSynchronisationResult(mappedGroups.getChangedEntities(), mappedGroups.getSyncToken());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException("background query interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private <T> void handleNamelessEntities(DeltaQueryResult<T> mappedEntities, String entityType) {
        Sets.SetView difference = Sets.difference(mappedEntities.getNamelessEntities(), mappedEntities.getDeletedEntities());
        if (difference.size() > 0) {
            log.warn("Azure AD returned the following {} without ids: {}", (Object)entityType, (Object)difference);
        }
    }
}

