/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.authentication.impl;

import com.atlassian.crowd.directory.authentication.AdalAuthenticationContextFactory;
import com.atlassian.crowd.directory.authentication.AdalAuthenticator;
import com.atlassian.crowd.exception.OperationFailedException;
import com.google.common.util.concurrent.MoreExecutors;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class SameThreadAdalAuthenticator
implements AdalAuthenticator {
    private final AdalAuthenticationContextFactory authenticationContextFactory;
    private final String clientId;
    private final String clientSecret;
    private final String authority;
    private ExecutorService sameThreadExecutorService = MoreExecutors.newDirectExecutorService();

    public SameThreadAdalAuthenticator(AdalAuthenticationContextFactory authenticationContextFactory, String clientId, String clientSecret, String authority) {
        this.authenticationContextFactory = authenticationContextFactory;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authority = authority;
    }

    @Override
    public AuthenticationResult getAdalAuthenticationToken() throws OperationFailedException {
        try {
            AuthenticationContext context = this.authenticationContextFactory.create(this.authority, this.sameThreadExecutorService);
            Future result = context.acquireToken("https://graph.microsoft.com", new ClientCredential(this.clientId, this.clientSecret), null);
            return (AuthenticationResult)result.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }
}

