/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.token;

public class TokenLifetime {
    private static final long DEFAULT_VALUE = -1L;
    private final long seconds;
    public static final TokenLifetime USE_DEFAULT = new TokenLifetime();

    private TokenLifetime() {
        this.seconds = -1L;
    }

    private TokenLifetime(long seconds) {
        if (seconds < 0L) {
            throw new IllegalArgumentException("The duration must be greater or equal to 0");
        }
        this.seconds = seconds;
    }

    public long getSeconds() {
        if (this.seconds < 0L) {
            throw new IllegalStateException("Default lifetime does not prescribe a particular duration");
        }
        return this.seconds;
    }

    public boolean isDefault() {
        return this.seconds == -1L;
    }

    public static TokenLifetime inSeconds(long seconds) {
        return new TokenLifetime(seconds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenLifetime that = (TokenLifetime)o;
        return this.seconds == that.seconds;
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32);
    }
}

