package com.atlassian.crowd.search.query;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;

public class DirectoryQueries {

    /**
     * Builds an EntityQuery for retrieving all defined directories
     * @return EntityQuery for retrieving all defined directories
     */
    public static EntityQuery<Directory> allDirectories() {
        return QueryBuilder.queryFor(Directory.class, EntityDescriptor.directory()).returningAtMost(EntityQuery.ALL_RESULTS);
    }
}
