package com.atlassian.crowd.model.sso;

import com.atlassian.annotations.Internal;
import org.apache.commons.lang3.StringUtils;

/**
 * Represents NameID formats supported by Crowd.
 *
 * @since 4.4.0
 */
@Internal
public enum NameIdFormat {
    UNSPECIFIED,
    EMAIL;

    public static NameIdFormat fromString(final String nameIdFormatString) {
        try {
            if (StringUtils.isNotBlank(nameIdFormatString)) {
                return NameIdFormat.valueOf(nameIdFormatString.toUpperCase());
            }
        } catch (final Exception ignore) {
            // fall back to UNSPECIFIED for all errors
        }

        return UNSPECIFIED;
    }
}
