package com.atlassian.crowd.manager.sso;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.user.ImmutableUser;
import com.atlassian.crowd.model.user.User;

/**
 * Exception thrown when user can log in to CROWD but not to a given application.
 */
public class ApplicationAccessDeniedException extends RuntimeException {
    private final ImmutableApplication application;
    private final ImmutableUser user;

    public ApplicationAccessDeniedException(Application application, User user) {
        super(String.format("User %s doesn't have access to application: %s.", user.getName(), application.getName()));
        this.application = ImmutableApplication.from(application);
        this.user = ImmutableUser.from(user);
    }

    public Application getApplication() {
        return application;
    }

    public User getUser() {
        return user;
    }
}
