package com.atlassian.crowd.audit;

import javax.annotation.Nullable;

/**
 * Represents an object affected by an auditable event.
 *
 * @since 3.2.0
 */
public interface AuditLogEntity {

    /**
     * @return the type of the affected object
     */
    @Nullable
    AuditLogEntityType getEntityType();

    /**
     * @return the identifier of the affected object
     * (exact semantic depends on the entity type)
     */
    @Nullable
    Long getEntityId();

    /**
     * Returns the name of the affected object. This is
     * particularly useful when the object does not exist anymore
     *
     * @return the name of the affected object at the time the event occurred
     */
    @Nullable
    String getEntityName();

    /**
     * @return Returns true if the object is the primary affected object in the transaction
     */
    boolean isPrimary();
}
