package com.atlassian.crowd.model.sso;

import com.atlassian.crowd.model.application.Application;

/**
 * Represents SAML SSO configuration for an application
 * @since 3.4.0
 */
public interface ApplicationSamlConfiguration extends BaseApplicationSamlConfiguration {
    /**
     * @return the application for which SAML SSO is configured
     */
    Application getApplication();

    /**
     * @return true if SAML SSO is enabled for the application, false otherwise
     */
    boolean isEnabled();
}
