package com.atlassian.crowd.manager.permission;


import com.atlassian.crowd.exception.CrowdException;

/**
 * Thrown when a User can not remove permissions from a group specifically because doing so
 * would downgrade their own permissions.
 */
public class UserPermissionDowngradeException extends CrowdException {
    final String groupName;

    public UserPermissionDowngradeException(String groupName, String s) {
        super(s);
        this.groupName = groupName;
    }

    public String getGroupName() {
        return groupName;
    }
}
