/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.mail;

import java.util.Objects;
import javax.mail.internet.InternetAddress;

public class SMTPServer {
    private String host;
    private String username;
    private String password;
    private InternetAddress from;
    private String prefix;
    private String jndiLocation;
    private int port;
    private boolean jndiMailActive;
    private boolean useSSL;
    public static final int DEFAULT_MAIL_PORT = 25;

    public SMTPServer(String jndiLocation, InternetAddress from, String prefix) {
        this.jndiLocation = jndiLocation;
        this.from = from;
        this.jndiMailActive = true;
        this.prefix = prefix;
    }

    public SMTPServer(int port, String prefix, InternetAddress from, String password, String username, String host, boolean useSSL) {
        this.jndiMailActive = false;
        this.port = port;
        this.prefix = prefix;
        this.from = from;
        this.password = password;
        this.username = username;
        this.host = host;
        this.useSSL = useSSL;
    }

    public SMTPServer() {
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public InternetAddress getFrom() {
        return this.from;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getPort() {
        return this.port;
    }

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    public boolean isJndiMailActive() {
        return this.jndiMailActive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMTPServer that = (SMTPServer)o;
        return this.port == that.port && this.jndiMailActive == that.jndiMailActive && this.useSSL == that.useSSL && Objects.equals(this.host, that.host) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.from, that.from) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.jndiLocation, that.jndiLocation);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.username, this.password, this.from, this.prefix, this.jndiLocation, this.port, this.jndiMailActive, this.useSSL);
    }
}

