/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.event.EventTokenExpiredException;
import com.atlassian.crowd.event.Events;
import com.atlassian.crowd.event.IncrementalSynchronisationNotAvailableException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.BulkAddFailedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ApplicationService {
    public User authenticateUser(Application var1, String var2, PasswordCredential var3) throws OperationFailedException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, UserNotFoundException;

    public boolean isUserAuthorised(Application var1, String var2);

    public void addAllUsers(Application var1, Collection<UserTemplateWithCredentialAndAttributes> var2) throws ApplicationPermissionException, OperationFailedException, BulkAddFailedException;

    public User findUserByName(Application var1, String var2) throws UserNotFoundException;

    public UserWithAttributes findUserWithAttributesByName(Application var1, String var2) throws UserNotFoundException;

    public User addUser(Application var1, UserTemplate var2, PasswordCredential var3) throws InvalidUserException, OperationFailedException, InvalidCredentialException, ApplicationPermissionException;

    public User updateUser(Application var1, UserTemplate var2) throws InvalidUserException, OperationFailedException, ApplicationPermissionException, UserNotFoundException;

    public void updateUserCredential(Application var1, String var2, PasswordCredential var3) throws OperationFailedException, UserNotFoundException, InvalidCredentialException, ApplicationPermissionException;

    public void resetUserCredential(Application var1, String var2) throws OperationFailedException, UserNotFoundException, InvalidCredentialException, ApplicationPermissionException, InvalidEmailAddressException;

    public void storeUserAttributes(Application var1, String var2, Map<String, Set<String>> var3) throws OperationFailedException, ApplicationPermissionException, UserNotFoundException;

    public void removeUserAttributes(Application var1, String var2, String var3) throws OperationFailedException, ApplicationPermissionException, UserNotFoundException;

    public void removeUser(Application var1, String var2) throws OperationFailedException, UserNotFoundException, ApplicationPermissionException;

    public <T> List<T> searchUsers(Application var1, EntityQuery<T> var2);

    public List<User> searchUsersAllowingDuplicateNames(Application var1, EntityQuery<User> var2);

    public Group findGroupByName(Application var1, String var2) throws GroupNotFoundException;

    public GroupWithAttributes findGroupWithAttributesByName(Application var1, String var2) throws GroupNotFoundException;

    public Group addGroup(Application var1, GroupTemplate var2) throws InvalidGroupException, OperationFailedException, ApplicationPermissionException;

    public Group updateGroup(Application var1, GroupTemplate var2) throws InvalidGroupException, OperationFailedException, ApplicationPermissionException, GroupNotFoundException;

    public void storeGroupAttributes(Application var1, String var2, Map<String, Set<String>> var3) throws OperationFailedException, ApplicationPermissionException, GroupNotFoundException;

    public void removeGroupAttributes(Application var1, String var2, String var3) throws OperationFailedException, ApplicationPermissionException, GroupNotFoundException;

    public void removeGroup(Application var1, String var2) throws OperationFailedException, GroupNotFoundException, ApplicationPermissionException;

    public <T> List<T> searchGroups(Application var1, EntityQuery<T> var2);

    public void addUserToGroup(Application var1, String var2, String var3) throws OperationFailedException, UserNotFoundException, GroupNotFoundException, ApplicationPermissionException;

    public void addGroupToGroup(Application var1, String var2, String var3) throws OperationFailedException, GroupNotFoundException, ApplicationPermissionException, InvalidMembershipException;

    public void removeUserFromGroup(Application var1, String var2, String var3) throws OperationFailedException, GroupNotFoundException, UserNotFoundException, ApplicationPermissionException, MembershipNotFoundException;

    public void removeGroupFromGroup(Application var1, String var2, String var3) throws OperationFailedException, GroupNotFoundException, ApplicationPermissionException, MembershipNotFoundException;

    public boolean isUserDirectGroupMember(Application var1, String var2, String var3);

    public boolean isGroupDirectGroupMember(Application var1, String var2, String var3);

    public boolean isUserNestedGroupMember(Application var1, String var2, String var3);

    public boolean isGroupNestedGroupMember(Application var1, String var2, String var3);

    public <T> List<T> searchDirectGroupRelationships(Application var1, MembershipQuery<T> var2);

    public <T> List<T> searchNestedGroupRelationships(Application var1, MembershipQuery<T> var2);

    public String getCurrentEventToken();

    public Events getNewEvents(Application var1, String var2) throws EventTokenExpiredException, OperationFailedException, IncrementalSynchronisationNotAvailableException;
}

