/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.mail;

import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;

public class SMTPServer {
    private String host;
    private String username;
    private String password;
    private InternetAddress from;
    private String prefix;
    private String jndiLocation;
    private String port;
    private boolean jndiMailActive;
    public static final int DEFAULT_MAIL_PORT = 25;

    public SMTPServer(String jndiLocation, InternetAddress from, String prefix) {
        this.jndiLocation = jndiLocation;
        this.from = from;
        this.jndiMailActive = true;
        this.prefix = prefix;
    }

    public SMTPServer(String port, String prefix, InternetAddress from, String password, String username, String host) {
        this.jndiMailActive = false;
        if (StringUtils.isNotBlank((String)port)) {
            try {
                Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("SMTP port number was not a valid number", e);
            }
            this.port = port;
        } else {
            this.port = Integer.toString(25);
        }
        this.prefix = prefix;
        this.from = from;
        this.password = password;
        this.username = username;
        this.host = host;
    }

    public SMTPServer() {
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public InternetAddress getFrom() {
        return this.from;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPort() {
        return this.port;
    }

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    public boolean isJndiMailActive() {
        return this.jndiMailActive;
    }
}

