/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.query.membership;

import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.ReturnType;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MembershipQuery {
    private final EntityDescriptor entityToReturn;
    private final EntityDescriptor entityToMatch;
    private final boolean findMembers;
    private final String entityNameToMatch;
    private final int startIndex;
    private final int maxResults;
    private ReturnType returnType;

    public MembershipQuery(boolean findMembers, EntityDescriptor entityToMatch, String entityNameToMatch, EntityDescriptor entityToReturn, int startIndex, int maxResults) {
        this(findMembers, entityToMatch, entityNameToMatch, entityToReturn, startIndex, maxResults, ReturnType.ENTITY);
    }

    public MembershipQuery(boolean findMembers, EntityDescriptor entityToMatch, String entityNameToMatch, EntityDescriptor entityToReturn, int startIndex, int maxResults, ReturnType returnType) {
        Validate.notNull((Object)entityToMatch, (String)"entityToMatch argument cannot be null");
        Validate.notNull((Object)entityNameToMatch, (String)"entityNameToMatch argument cannot be null");
        Validate.notNull((Object)entityToReturn, (String)"entityToReturn argument cannot be null");
        Validate.isTrue((maxResults <= 1000 ? 1 : 0) != 0, (String)"maxResults cannot be more than 1000");
        Validate.isTrue((startIndex >= 0 ? 1 : 0) != 0, (String)"startIndex cannot be less than zero");
        Validate.notNull((Object)((Object)returnType), (String)"returnType cannot be null");
        if (findMembers) {
            Validate.isTrue((entityToMatch.getEntityType() == Entity.GROUP ? 1 : 0) != 0, (String)("Cannot find the members of type: " + entityToMatch));
        } else {
            Validate.isTrue((entityToReturn.getEntityType() == Entity.GROUP ? 1 : 0) != 0, (String)("Cannot return memberships of type: " + entityToMatch));
        }
        this.entityToReturn = entityToReturn;
        this.entityToMatch = entityToMatch;
        this.findMembers = findMembers;
        this.entityNameToMatch = entityNameToMatch;
        this.startIndex = startIndex;
        this.maxResults = maxResults;
        this.returnType = returnType;
    }

    public MembershipQuery(MembershipQuery query, int startIndex, int maxResults) {
        this(query.isFindMembers(), query.getEntityToMatch(), query.getEntityNameToMatch(), query.getEntityToReturn(), startIndex, maxResults, query.getReturnType());
    }

    public EntityDescriptor getEntityToReturn() {
        return this.entityToReturn;
    }

    public EntityDescriptor getEntityToMatch() {
        return this.entityToMatch;
    }

    public boolean isFindMembers() {
        return this.findMembers;
    }

    public String getEntityNameToMatch() {
        return this.entityNameToMatch;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    public MembershipQuery asNames() {
        this.returnType = ReturnType.NAME;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MembershipQuery)) {
            return false;
        }
        MembershipQuery that = (MembershipQuery)o;
        if (this.findMembers != that.findMembers) {
            return false;
        }
        if (this.maxResults != that.maxResults) {
            return false;
        }
        if (this.startIndex != that.startIndex) {
            return false;
        }
        if (this.entityNameToMatch != null ? !this.entityNameToMatch.equals(that.entityNameToMatch) : that.entityNameToMatch != null) {
            return false;
        }
        if (this.entityToMatch != null ? !this.entityToMatch.equals(that.entityToMatch) : that.entityToMatch != null) {
            return false;
        }
        if (this.entityToReturn != null ? !this.entityToReturn.equals(that.entityToReturn) : that.entityToReturn != null) {
            return false;
        }
        return this.returnType == that.returnType;
    }

    public int hashCode() {
        int result = this.entityToReturn != null ? this.entityToReturn.hashCode() : 0;
        result = 31 * result + (this.entityToMatch != null ? this.entityToMatch.hashCode() : 0);
        result = 31 * result + (this.findMembers ? 1 : 0);
        result = 31 * result + (this.entityNameToMatch != null ? this.entityNameToMatch.hashCode() : 0);
        result = 31 * result + this.startIndex;
        result = 31 * result + this.maxResults;
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("entityToReturn", (Object)this.entityToReturn).append("entityToMatch", (Object)this.entityToMatch).append("findMembers", this.findMembers).append("entityNameToMatch", (Object)this.entityNameToMatch).append("startIndex", this.startIndex).append("maxResults", this.maxResults).toString();
    }
}

