/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.query.entity.restriction;

import com.atlassian.crowd.search.query.entity.restriction.SearchRestriction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTermRestriction
implements SearchRestriction {
    private final Collection<SearchRestriction> restrictions;
    private final BooleanLogic booleanLogic;

    public MultiTermRestriction(BooleanLogic booleanLogic, SearchRestriction ... restrictions) {
        this(booleanLogic, Arrays.asList(restrictions));
    }

    public MultiTermRestriction(BooleanLogic booleanLogic, Collection<SearchRestriction> restrictions) {
        Validate.notNull((Object)((Object)booleanLogic), (String)"booleanLogic cannot be null");
        Validate.notEmpty(restrictions, (String)"booleanLogic cannot be empty");
        this.restrictions = restrictions;
        this.booleanLogic = booleanLogic;
    }

    public Collection<SearchRestriction> getRestrictions() {
        return Collections.unmodifiableCollection(this.restrictions);
    }

    public BooleanLogic getBooleanLogic() {
        return this.booleanLogic;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("restrictions", this.restrictions).append("booleanLogic", (Object)this.booleanLogic).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTermRestriction that = (MultiTermRestriction)o;
        if (this.booleanLogic != that.booleanLogic) {
            return false;
        }
        return !(this.restrictions != null ? !((Object)this.restrictions).equals(that.restrictions) : that.restrictions != null);
    }

    public int hashCode() {
        int result = this.restrictions != null ? ((Object)this.restrictions).hashCode() : 0;
        result = 31 * result + (this.booleanLogic != null ? this.booleanLogic.hashCode() : 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BooleanLogic {
        AND,
        OR;

    }
}

