/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.builder;

import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.SearchRestriction;
import com.atlassian.crowd.search.query.membership.MembershipQuery;

public class QueryBuilder {
    private static final SearchRestriction DEFAULT_RESTRICTION = new NullRestriction();
    private static final int DEFAULT_START_INDEX = 0;

    public static PartialEntityQuery queryFor(EntityDescriptor entity) {
        return new PartialEntityQuery(entity);
    }

    public static class PartialEntityQueryWithStartIndex {
        private final EntityDescriptor entity;
        private final SearchRestriction restriction;
        private final int startIndex;

        public PartialEntityQueryWithStartIndex(EntityDescriptor entity, SearchRestriction restriction, int startIndex) {
            this.entity = entity;
            this.startIndex = startIndex;
            this.restriction = restriction;
        }

        public EntityQuery returningAtMost(int maxResults) {
            return new EntityQuery(this.entity, this.restriction, this.startIndex, maxResults);
        }
    }

    public static class PartialEntityQueryWithRestriction {
        private final EntityDescriptor entity;
        private final SearchRestriction restriction;

        public PartialEntityQueryWithRestriction(EntityDescriptor entity, SearchRestriction restriction) {
            this.entity = entity;
            this.restriction = restriction;
        }

        public PartialEntityQueryWithStartIndex startingAt(int index) {
            return new PartialEntityQueryWithStartIndex(this.entity, this.restriction, index);
        }

        public EntityQuery returningAtMost(int maxResults) {
            return new EntityQuery(this.entity, this.restriction, 0, maxResults);
        }
    }

    public static class PartialMembershipQueryWithStartIndex {
        private final EntityDescriptor entityToReturn;
        private final EntityDescriptor entityToMatch;
        private final boolean findMembers;
        private final String nameToMatch;
        private final int startIndex;

        public PartialMembershipQueryWithStartIndex(EntityDescriptor entityToReturn, EntityDescriptor entityToMatch, boolean findMembers, String nameToMatch, int startIndex) {
            this.entityToReturn = entityToReturn;
            this.entityToMatch = entityToMatch;
            this.findMembers = findMembers;
            this.nameToMatch = nameToMatch;
            this.startIndex = startIndex;
        }

        public MembershipQuery returningAtMost(int maxResults) {
            return new MembershipQuery(this.findMembers, this.entityToMatch, this.nameToMatch, this.entityToReturn, this.startIndex, maxResults);
        }
    }

    public static class PartialMembershipQueryWithNameToMatch {
        private final EntityDescriptor entityToReturn;
        private final EntityDescriptor entityToMatch;
        private final boolean findMembers;
        private final String nameToMatch;

        public PartialMembershipQueryWithNameToMatch(EntityDescriptor entityToReturn, EntityDescriptor entityToMatch, boolean findMembers, String nameToMatch) {
            this.entityToReturn = entityToReturn;
            this.entityToMatch = entityToMatch;
            this.findMembers = findMembers;
            this.nameToMatch = nameToMatch;
        }

        public PartialMembershipQueryWithStartIndex startingAt(int index) {
            return new PartialMembershipQueryWithStartIndex(this.entityToReturn, this.entityToMatch, this.findMembers, this.nameToMatch, index);
        }

        public MembershipQuery returningAtMost(int maxResults) {
            return new MembershipQuery(this.findMembers, this.entityToMatch, this.nameToMatch, this.entityToReturn, 0, maxResults);
        }
    }

    public static class PartialMembershipQueryWithEntityToMatch {
        private final EntityDescriptor entityToReturn;
        private final EntityDescriptor entityToMatch;
        private final boolean findMembers;

        public PartialMembershipQueryWithEntityToMatch(EntityDescriptor entityToReturn, EntityDescriptor entityToMatch, boolean findMembers) {
            this.entityToReturn = entityToReturn;
            this.entityToMatch = entityToMatch;
            this.findMembers = findMembers;
        }

        public PartialMembershipQueryWithNameToMatch withName(String name) {
            return new PartialMembershipQueryWithNameToMatch(this.entityToReturn, this.entityToMatch, this.findMembers, name);
        }
    }

    public static class PartialEntityQuery {
        private final EntityDescriptor entity;

        public PartialEntityQuery(EntityDescriptor entity) {
            this.entity = entity;
        }

        public PartialEntityQueryWithRestriction with(SearchRestriction restriction) {
            return new PartialEntityQueryWithRestriction(this.entity, restriction);
        }

        public PartialEntityQueryWithStartIndex startingAt(int index) {
            return new PartialEntityQueryWithStartIndex(this.entity, DEFAULT_RESTRICTION, index);
        }

        public EntityQuery returningAtMost(int maxResults) {
            return new EntityQuery(this.entity, DEFAULT_RESTRICTION, 0, maxResults);
        }

        public PartialMembershipQueryWithEntityToMatch membersOf(EntityDescriptor entityToMatch) {
            return new PartialMembershipQueryWithEntityToMatch(this.entity, entityToMatch, true);
        }

        public PartialMembershipQueryWithEntityToMatch membershipsOf(EntityDescriptor entityToMatch) {
            return new PartialMembershipQueryWithEntityToMatch(this.entity, entityToMatch, false);
        }

        public Object ofType(GroupType groupType) {
            return null;
        }
    }
}

