/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.application;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.model.AttributeAware;
import com.atlassian.crowd.integration.model.InternalEntity;
import com.atlassian.crowd.integration.model.InternalEntityTemplate;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.OperationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
extends InternalEntity
implements AttributeAware {
    public static final String ATTRIBUTE_KEY_ATLASSIAN_SHA1_APPLIED = "atlassian_sha1_applied";
    public static final String ATTRIBUTE_KEY_APPLICATION_URL = "applicationURL";
    private static final String ATTRIBUTE_KEY_LOWER_CASE_OUTPUT = "lowerCaseOutput";
    private static final String ATTRIBUTE_KEY_ALIASING_ENABLED = "aliasingEnabled";
    private String lowerName;
    private ApplicationType type;
    private String description;
    private PasswordCredential credential;
    private Map<String, String> attributes = new HashMap<String, String>();
    private List<DirectoryMapping> directoryMappings = new ArrayList<DirectoryMapping>();
    private Set<RemoteAddress> remoteAddresses = new HashSet<RemoteAddress>();

    protected Application() {
    }

    public Application(String name, ApplicationType type, PasswordCredential credential) {
        this.setName(name);
        this.type = type;
        this.credential = credential;
    }

    public Application(String name, ApplicationType type, String credential) {
        this.setName(name);
        this.type = type;
        this.credential = new PasswordCredential(credential);
    }

    public Application(InternalEntityTemplate template) {
        super(template);
    }

    public void validate() {
        Validate.notNull((Object)this.name, (String)"name cannot be null");
        Validate.isTrue((boolean)this.name.toLowerCase().equals(this.lowerName), (String)"lowerName must be the lower-case representation of name");
        Validate.notNull((Object)((Object)this.type), (String)"type cannot be null");
        Validate.notNull((Object)this.credential, (String)"credential cannot be null");
        Validate.notNull((Object)this.credential.getCredential(), (String)"credential cannot have null value");
        Validate.isTrue((boolean)this.credential.isEncryptedCredential(), (String)"credential must be encrypted");
        Validate.notNull((Object)this.createdDate, (String)"createdDate cannot be null");
        Validate.notNull((Object)this.updatedDate, (String)"updatedDate cannot be null");
        Validate.notNull(this.attributes, (String)"attributes cannot be null");
        Validate.notNull(this.directoryMappings, (String)"directoryMappings cannot be null");
        Validate.notNull(this.remoteAddresses, (String)"remoteAddresses cannot be null");
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.lowerName = name.toLowerCase();
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    public String getLowerName() {
        return this.lowerName;
    }

    private void setLowerName(String lowerName) {
        this.lowerName = lowerName;
    }

    public ApplicationType getType() {
        return this.type;
    }

    public void setType(ApplicationType type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PasswordCredential getCredential() {
        return this.credential;
    }

    public void setCredential(PasswordCredential credential) {
        this.credential = credential;
    }

    public boolean isPermanent() {
        return this.getType().equals((Object)ApplicationType.CROWD);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public List<DirectoryMapping> getDirectoryMappings() {
        return this.directoryMappings;
    }

    public DirectoryMapping addDirectoryMapping(Directory directory, boolean allowAllToAuthenticate, OperationType ... operationTypes) {
        DirectoryMapping mapping = new DirectoryMapping(this, directory, allowAllToAuthenticate, new HashSet<OperationType>(Arrays.asList(operationTypes)));
        this.getDirectoryMappings().add(mapping);
        return mapping;
    }

    public DirectoryMapping getDirectoryMapping(long directoryId) {
        for (DirectoryMapping mapping : this.getDirectoryMappings()) {
            if (mapping.getDirectory().getId() != directoryId) continue;
            return mapping;
        }
        return null;
    }

    public boolean removeDirectoryMapping(long directoryId) {
        DirectoryMapping mapping = this.getDirectoryMapping(directoryId);
        return this.getDirectoryMappings().remove(mapping);
    }

    public void setDirectoryMappings(List<DirectoryMapping> directoryMappings) {
        this.directoryMappings = directoryMappings;
    }

    public Set<RemoteAddress> getRemoteAddresses() {
        return this.remoteAddresses;
    }

    public void addRemoteAddress(String remoteAddress) {
        this.getRemoteAddresses().add(new RemoteAddress(remoteAddress));
    }

    public void setRemoteAddresses(Set<RemoteAddress> remoteAddresses) {
        this.remoteAddresses = remoteAddresses;
    }

    public boolean hasRemoteAddress(String remoteAddress) {
        return this.getRemoteAddresses().contains(new RemoteAddress(remoteAddress));
    }

    public boolean removeRemoteAddress(String remoteAddress) {
        return this.getRemoteAddresses().remove(new RemoteAddress(remoteAddress));
    }

    public List<String> getAttributes(String name) {
        String value = this.getAttribute(name);
        if (value != null) {
            return Arrays.asList(value);
        }
        return null;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public boolean isLowerCaseOutput() {
        String val = this.getAttribute(ATTRIBUTE_KEY_LOWER_CASE_OUTPUT);
        return val != null && Boolean.parseBoolean(val);
    }

    public void setLowerCaseOutput(boolean value) {
        this.setAttribute(ATTRIBUTE_KEY_LOWER_CASE_OUTPUT, Boolean.toString(value));
    }

    public void setAliasingEnabled(boolean aliasingEnabled) {
        this.setAttribute(ATTRIBUTE_KEY_ALIASING_ENABLED, Boolean.toString(aliasingEnabled));
    }

    public boolean isAliasingEnabled() {
        String val = this.getAttribute(ATTRIBUTE_KEY_ALIASING_ENABLED);
        return val != null && Boolean.parseBoolean(val);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application that = (Application)o;
        return !(this.getLowerName() != null ? !this.getLowerName().equals(that.getLowerName()) : that.getLowerName() != null);
    }

    @Override
    public int hashCode() {
        return this.getLowerName() != null ? this.getLowerName().hashCode() : 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("lowerName", (Object)this.getLowerName()).append("type", (Object)this.getType()).append("description", (Object)this.getDescription()).append("credential", (Object)this.getCredential()).append("attributes", this.getAttributes()).append("directoryMappings", this.getDirectoryMappings()).append("remoteAddresses", this.getRemoteAddresses()).toString();
    }
}

