/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.DirectoryInstantiationException;
import com.atlassian.crowd.integration.exception.DirectoryPermissionException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidMembershipException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.MembershipNotFoundException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.integration.model.user.UserWithAttributes;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DirectoryManager {
    public Directory addDirectory(Directory var1) throws DirectoryInstantiationException;

    public Directory findDirectoryById(long var1) throws ObjectNotFoundException;

    public List<Directory> findAllDirectories();

    public List<Directory> searchDirectories(EntityQuery var1);

    public Directory findDirectoryByName(String var1) throws ObjectNotFoundException;

    public Directory updateDirectory(Directory var1) throws ObjectNotFoundException;

    public void removeDirectory(Directory var1) throws ObjectNotFoundException;

    public void invalidateToken(String var1);

    public List<Token> searchTokens(EntityQuery var1);

    public void removeExpiredTokens();

    public User findUserByToken(String var1) throws InvalidTokenException, DirectoryAccessException;

    public User findUserByName(long var1, String var3) throws ObjectNotFoundException, DirectoryAccessException;

    public UserWithAttributes findUserWithAttributesByName(long var1, String var3) throws ObjectNotFoundException, DirectoryAccessException;

    public List searchUsers(long var1, EntityQuery var3) throws DirectoryAccessException, ObjectNotFoundException;

    public User addUser(long var1, UserTemplate var3, PasswordCredential var4) throws InvalidCredentialException, InvalidUserException, DirectoryAccessException, DirectoryPermissionException, ObjectNotFoundException;

    public User updateUser(long var1, UserTemplate var3) throws ObjectNotFoundException, DirectoryAccessException, DirectoryPermissionException, InvalidUserException;

    public User renameUser(long var1, String var3, String var4) throws ObjectNotFoundException, DirectoryAccessException, DirectoryPermissionException, InvalidUserException;

    public void storeUserAttributes(long var1, String var3, Map<String, List<String>> var4) throws DirectoryAccessException, DirectoryPermissionException, ObjectNotFoundException;

    public void removeUserAttributes(long var1, String var3, String var4) throws DirectoryAccessException, DirectoryPermissionException, ObjectNotFoundException;

    public void updateUserCredential(long var1, String var3, PasswordCredential var4) throws DirectoryAccessException, DirectoryPermissionException, InvalidCredentialException, ObjectNotFoundException;

    public void resetPassword(long var1, String var3) throws ObjectNotFoundException, DirectoryAccessException, InvalidEmailAddressException, DirectoryPermissionException, InvalidCredentialException;

    public void removeUser(long var1, String var3) throws ObjectNotFoundException, DirectoryPermissionException, DirectoryAccessException;

    public Group findGroupByName(long var1, String var3) throws ObjectNotFoundException, DirectoryAccessException;

    public GroupWithAttributes findGroupWithAttributesByName(long var1, String var3) throws ObjectNotFoundException, DirectoryAccessException;

    public List searchGroups(long var1, EntityQuery var3) throws DirectoryAccessException, ObjectNotFoundException;

    public Group addGroup(long var1, GroupTemplate var3) throws InvalidGroupException, DirectoryAccessException, DirectoryPermissionException, ObjectNotFoundException;

    public Group updateGroup(long var1, GroupTemplate var3) throws ObjectNotFoundException, DirectoryAccessException, DirectoryPermissionException, InvalidGroupException;

    public Group renameGroup(long var1, String var3, String var4) throws ObjectNotFoundException, DirectoryAccessException, DirectoryPermissionException, InvalidGroupException;

    public void storeGroupAttributes(long var1, String var3, Map<String, List<String>> var4) throws DirectoryAccessException, DirectoryPermissionException, ObjectNotFoundException;

    public void removeGroupAttributes(long var1, String var3, String var4) throws DirectoryAccessException, DirectoryPermissionException, ObjectNotFoundException;

    public void removeGroup(long var1, String var3) throws ObjectNotFoundException, DirectoryPermissionException, DirectoryAccessException;

    public boolean isUserDirectGroupMember(long var1, String var3, String var4) throws ObjectNotFoundException, DirectoryAccessException;

    public boolean isGroupDirectGroupMember(long var1, String var3, String var4) throws ObjectNotFoundException, DirectoryAccessException;

    public void addUserToGroup(long var1, String var3, String var4) throws DirectoryPermissionException, ObjectNotFoundException, DirectoryAccessException;

    public void addGroupToGroup(long var1, String var3, String var4) throws DirectoryPermissionException, ObjectNotFoundException, DirectoryAccessException, InvalidMembershipException;

    public void removeUserFromGroup(long var1, String var3, String var4) throws DirectoryPermissionException, ObjectNotFoundException, DirectoryAccessException, MembershipNotFoundException;

    public void removeGroupFromGroup(long var1, String var3, String var4) throws DirectoryPermissionException, ObjectNotFoundException, DirectoryAccessException, InvalidMembershipException, MembershipNotFoundException;

    public List searchDirectGroupRelationships(long var1, MembershipQuery var3) throws ObjectNotFoundException, DirectoryAccessException;

    public boolean isUserNestedGroupMember(long var1, String var3, String var4) throws ObjectNotFoundException, DirectoryAccessException;

    public boolean isGroupNestedGroupMember(long var1, String var3, String var4) throws ObjectNotFoundException, DirectoryAccessException;

    public List searchNestedGroupRelationships(long var1, MembershipQuery var3) throws ObjectNotFoundException, DirectoryAccessException;

    public BulkAddResult<User> addAllUsers(long var1, Collection<UserTemplateWithCredentialAndAttributes> var3, boolean var4) throws DirectoryPermissionException, DirectoryAccessException, ObjectNotFoundException;

    public BulkAddResult<Group> addAllGroups(long var1, Collection<GroupTemplate> var3, boolean var4) throws DirectoryPermissionException, DirectoryAccessException, ObjectNotFoundException;

    public BulkAddResult<String> addAllUsersToGroup(long var1, Collection<String> var3, String var4) throws DirectoryPermissionException, DirectoryAccessException, ObjectNotFoundException;
}

