/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model.user;

import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.integration.model.user.UserWithAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserTemplateWithAttributes
extends UserTemplate
implements UserWithAttributes {
    private final Map<String, List<String>> attributes = new HashMap<String, List<String>>();

    public UserTemplateWithAttributes(String username, Long directoryId) {
        super(username, directoryId);
    }

    public UserTemplateWithAttributes(User user) {
        super(user);
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public List<String> getAttributes(String name) {
        return this.attributes.get(name);
    }

    public String getAttribute(String name) {
        List<String> vals = this.getAttributes(name);
        if (vals != null && vals.size() > 0) {
            return vals.get(0);
        }
        return null;
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, Arrays.asList(value));
    }

    public void setAttribute(String name, List<String> values) {
        this.attributes.put(name, values);
    }
}

