/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model.group;

import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.GroupWithAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupTemplateWithAttributes
extends GroupTemplate
implements GroupWithAttributes {
    private final Map<String, List<String>> attributes = new HashMap<String, List<String>>();

    public GroupTemplateWithAttributes(String groupName, Long directoryId, GroupType groupType) {
        super(groupName, directoryId, groupType);
    }

    public GroupTemplateWithAttributes(Group group) {
        super(group);
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public List<String> getAttributes(String name) {
        return this.attributes.get(name);
    }

    public String getAttribute(String name) {
        List<String> vals = this.getAttributes(name);
        if (vals != null && vals.size() > 0) {
            return vals.get(0);
        }
        return null;
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, Arrays.asList(value));
    }

    public void setAttribute(String name, List<String> values) {
        this.attributes.put(name, values);
    }
}

