/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.batch;

import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchResult<T> {
    private long totalAttempted;
    private Collection<T> failedEntities;

    public BatchResult(long totalEntities) {
        this.totalAttempted = totalEntities;
        this.failedEntities = new ArrayList<T>();
    }

    public void addFailure(T entity) {
        this.failedEntities.add(entity);
    }

    public boolean hasFailures() {
        return !this.failedEntities.isEmpty();
    }

    public long getTotalAttempted() {
        return this.totalAttempted;
    }

    public Collection<T> getFailedEntities() {
        return this.failedEntities;
    }

    public long getTotalSuccessful() {
        return this.totalAttempted - (long)this.failedEntities.size();
    }
}

