/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.crowd.util.persistence.hibernate.TransparentConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class MappingResources
implements InitializingBean {
    private List mappings = new ArrayList();
    private Resource configLocation;
    private List tableNames;

    public void setMappings(List mappings) {
        this.mappings.addAll(mappings);
    }

    public void addMapping(String mapping) {
        this.mappings.add(mapping);
    }

    public List getMappings() {
        return this.mappings;
    }

    public Resource getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public String[] getMappingsAsArray() {
        String[] map = new String[this.mappings.size()];
        for (int i = 0; i < this.mappings.size(); ++i) {
            map[i] = (String)this.mappings.get(i);
        }
        return map;
    }

    public List getTableNames() {
        return this.tableNames;
    }

    public void afterPropertiesSet() throws Exception {
        TransparentConfiguration config = new TransparentConfiguration();
        if (this.configLocation != null) {
            config.configure(this.configLocation.getURL());
            this.mappings = config.getMappingFiles();
        } else if (this.mappings != null) {
            for (String hbmFile : this.mappings) {
                config.addResource(hbmFile);
            }
        }
        if (this.mappings == null || this.mappings.isEmpty()) {
            throw new Exception("Misconfigured mappings/configLocation property on MappingResources bean: no hbm.xml mappings found.");
        }
        this.tableNames = new ArrayList(config.getTables().keySet());
    }
}

