/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.token;

import com.atlassian.crowd.authentication.SessionTimer;
import com.atlassian.crowd.integration.util.Assert;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Token
implements Serializable {
    private long ID;
    private String key;
    private String secretNumber;
    private SessionTimer session;
    private String name;
    private long directoryID = -1L;
    public static final long APPLICATION_TOKEN_DIRECTORY_ID = -1L;

    private Token() {
    }

    public Token(long directoryID, String name, String secretNumber, String key) {
        Assert.notNull((Object)directoryID, (String)"You cannot create a token with a null directory id");
        this.directoryID = directoryID;
        Assert.notNull((Object)name, (String)"You cannot create a token with a null name");
        this.name = name;
        Assert.notNull((Object)secretNumber, (String)"You cannot create a token with a null secret number");
        this.secretNumber = secretNumber;
        Assert.notNull((Object)key, (String)"You cannot create a token with a null key");
        this.key = key;
        this.session = new SessionTimer(new Date());
    }

    public Token(long directoryID, String name, String secretNumber, String key, SessionTimer session) {
        this(directoryID, name, secretNumber, key);
        Assert.notNull((Object)session, (String)"You cannot create a token with a null session");
        this.session = session;
    }

    public long getID() {
        return this.ID;
    }

    public void setID(long ID) {
        this.ID = ID;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public SessionTimer getSession() {
        return this.session;
    }

    public void setSession(SessionTimer session) {
        this.session = session;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getDirectoryID() {
        return this.directoryID;
    }

    public void setDirectoryID(long directoryID) {
        this.directoryID = directoryID;
    }

    public String getSecretNumber() {
        return this.secretNumber;
    }

    public void setSecretNumber(String secretNumber) {
        this.secretNumber = secretNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token token = (Token)o;
        if (this.directoryID != token.directoryID) {
            return false;
        }
        if (this.secretNumber != token.secretNumber) {
            return false;
        }
        if (!this.key.equals(token.key)) {
            return false;
        }
        if (!this.name.equals(token.name)) {
            return false;
        }
        return this.session.equals(token.session);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.secretNumber.hashCode();
        result = 31 * result + this.session.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (int)(this.directoryID ^ this.directoryID >>> 32);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("ID", this.ID).append("key", (Object)this.key).append("name", (Object)this.name).append("secretNumber", (Object)this.secretNumber).append("Directory ID", this.directoryID).toString();
    }
}

