/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.directory;

import com.atlassian.crowd.integration.directory.RemoteDirectory;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.model.directory.DirectoryInstanceLoader;
import com.atlassian.crowd.model.directory.DirectoryInstantiationException;
import com.atlassian.crowd.model.directory.DirectoryPermission;
import com.atlassian.crowd.model.directory.DirectoryType;
import com.atlassian.spring.container.ContainerManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Directory
extends DirectoryEntity
implements Serializable {
    public static final String ATTRIBUTE_KEY_USE_CACHING = "useCaching";
    public static final String ATTRIBUTE_KEY_USE_MONITORING = "useMonitoring";
    public static final String ATTRIBUTE_KEY_CACHE_CLASS = "cacheClass";
    public static final String ATTRIBUTE_KEY_CACHE_MAX_ELEMENTS_IN_MEMORY = "cacheMaxElements";
    public static final String ATTRIBUTE_KEY_POLLING_INTERVAL = "pollingInterval";
    private DirectoryType type;
    private String implementationClass;
    private List<DirectoryPermission> permissions;

    public Directory() {
    }

    public Directory(String name) {
        this.name = name;
    }

    public DirectoryType getType() {
        return this.type;
    }

    public String getEncryptionType() {
        String encryptionType = "com.atlassian.crowd.integration.directory.internal.InternalDirectory".equals(this.getImplementationClass()) ? this.getSingleAttributeValue("user_encryption_method") : this.getSingleAttributeValue("ldap.user.encryption");
        return encryptionType;
    }

    public void setType(DirectoryType type) {
        this.type = type;
    }

    public String getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(String implementationClass) {
        this.implementationClass = implementationClass;
    }

    public RemoteDirectory getImplementation() throws DirectoryInstantiationException {
        return ((DirectoryInstanceLoader)ContainerManager.getComponent((String)"directoryInstanceLoader")).getDirectory(this);
    }

    public RemoteDirectory getRawImplementation() throws DirectoryInstantiationException {
        return ((DirectoryInstanceLoader)ContainerManager.getComponent((String)"directoryInstanceLoader")).getRawDirectory(this);
    }

    public List<DirectoryPermission> getPermissions() {
        if (this.permissions == null) {
            return new ArrayList<DirectoryPermission>(0);
        }
        return this.permissions;
    }

    public void setPermissions(List<DirectoryPermission> permissions) {
        this.permissions = permissions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Directory directory = (Directory)o;
        if (this.implementationClass != null ? !this.implementationClass.equals(directory.implementationClass) : directory.implementationClass != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals((Object)directory.type) : directory.type != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.implementationClass != null ? this.implementationClass.hashCode() : 0);
        return result;
    }
}

