/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.integration.SearchContext;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.exception.DirectoryPermissionException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidPrincipalException;
import com.atlassian.crowd.integration.exception.InvalidRoleException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.AttributeValues;
import com.atlassian.crowd.integration.model.RemoteGroup;
import com.atlassian.crowd.integration.model.RemotePrincipal;
import com.atlassian.crowd.integration.model.RemoteRole;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.DirectoryManagerException;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.token.Token;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DirectoryManager {
    public Directory addDirectory(Directory var1) throws RemoteException;

    public RemotePrincipal addPrincipal(long var1, RemotePrincipal var3) throws InvalidCredentialException, InvalidPrincipalException, RemoteException, DirectoryPermissionException, ObjectNotFoundException;

    public RemoteGroup addGroup(long var1, RemoteGroup var3) throws InvalidGroupException, RemoteException, DirectoryPermissionException, ObjectNotFoundException;

    public Directory findDirectoryByID(long var1) throws ObjectNotFoundException;

    public void invalidateToken(String var1);

    public List<Directory> searchDirectories(SearchContext var1);

    public Directory findDirectoryByName(String var1) throws ObjectNotFoundException;

    public Directory updateDirectory(Directory var1) throws ObjectNotFoundException;

    public void removeDirectory(Directory var1) throws DirectoryManagerException, ObjectNotFoundException;

    public List<RemoteGroup> searchGroups(SearchContext var1) throws DirectoryManagerException, RemoteException;

    public List<RemoteRole> searchRoles(SearchContext var1) throws DirectoryManagerException, RemoteException;

    public List<RemotePrincipal> searchPrincipals(SearchContext var1) throws DirectoryManagerException, RemoteException;

    public RemoteGroup findGroupByName(long var1, String var3) throws ObjectNotFoundException, RemoteException;

    public RemoteGroup findGroupByName(long var1, String var3, boolean var4) throws ObjectNotFoundException, RemoteException;

    public RemoteRole findRoleByName(long var1, String var3) throws ObjectNotFoundException, RemoteException;

    public RemoteGroup updateGroup(long var1, RemoteGroup var3) throws ObjectNotFoundException, RemoteException, DirectoryPermissionException;

    public RemoteRole addRole(long var1, RemoteRole var3) throws InvalidRoleException, RemoteException, DirectoryPermissionException, ObjectNotFoundException;

    public RemoteRole updateRole(long var1, RemoteRole var3) throws ObjectNotFoundException, RemoteException, DirectoryPermissionException;

    public void removeGroup(long var1, String var3) throws ObjectNotFoundException, DirectoryPermissionException, RemoteException;

    public void removeRole(long var1, String var3) throws ObjectNotFoundException, DirectoryPermissionException, RemoteException;

    public void removePrincipalFromGroup(long var1, String var3, String var4) throws ObjectNotFoundException, RemoteException, DirectoryPermissionException;

    public void removePrincipalFromRole(long var1, String var3, String var4) throws ObjectNotFoundException, RemoteException, DirectoryPermissionException;

    public void removePrincipal(long var1, String var3) throws ObjectNotFoundException, DirectoryPermissionException, RemoteException;

    public RemotePrincipal findPrincipalByName(long var1, String var3) throws ObjectNotFoundException, RemoteException;

    public RemotePrincipal updatePrincipal(long var1, RemotePrincipal var3) throws ObjectNotFoundException, RemoteException, DirectoryPermissionException;

    public void addPrincipalToGroup(long var1, String var3, String var4) throws ObjectNotFoundException, RemoteException, DirectoryPermissionException;

    public void addPrincipalToRole(long var1, String var3, String var4) throws ObjectNotFoundException, RemoteException, DirectoryPermissionException;

    public List<Token> searchTokens(SearchContext var1) throws DirectoryManagerException;

    public void expireToken(String var1) throws ObjectNotFoundException, DirectoryManagerException;

    public void removeExpiredTokens() throws DirectoryManagerException;

    public void resetPassword(long var1, String var3) throws ObjectNotFoundException, RemoteException, InvalidEmailAddressException, DirectoryPermissionException, InvalidCredentialException;

    public boolean isRoleMember(long var1, String var3, String var4) throws RemoteException;

    public boolean isGroupMember(long var1, String var3, String var4) throws RemoteException;

    public RemotePrincipal findPrincipalByToken(String var1) throws InvalidTokenException, RemoteException;

    public void updatePrincipalCredential(long var1, String var3, PasswordCredential var4) throws RemoteException, DirectoryPermissionException, InvalidCredentialException, ObjectNotFoundException;

    public List<RemoteGroup> findGroupMemberships(long var1, String var3) throws ObjectNotFoundException, RemoteException;

    public List<RemoteRole> findRoleMemberships(long var1, String var3) throws ObjectNotFoundException, RemoteException;

    public void addPrincipalAttribute(long var1, RemotePrincipal var3, String var4, AttributeValues var5) throws RemoteException, DirectoryPermissionException, ObjectNotFoundException;

    public void removePrincipalAttribute(long var1, RemotePrincipal var3, String var4) throws RemoteException, DirectoryPermissionException, ObjectNotFoundException;

    public BulkAddResult<RemotePrincipal> addAllPrincipals(long var1, Collection<RemotePrincipal> var3, boolean var4) throws DirectoryPermissionException, RemoteException, ObjectNotFoundException;

    public BulkAddResult<RemoteGroup> addAllGroups(long var1, Collection<RemoteGroup> var3, boolean var4) throws DirectoryPermissionException, RemoteException, ObjectNotFoundException;

    public BulkAddResult<RemoteRole> addAllRoles(long var1, Collection<RemoteRole> var3, boolean var4) throws DirectoryPermissionException, RemoteException, ObjectNotFoundException;

    public BulkAddResult<String> addAllPrincipalsToGroup(long var1, Collection<String> var3, String var4) throws DirectoryPermissionException, RemoteException, ObjectNotFoundException;

    public BulkAddResult<String> addAllPrincipalsToRole(long var1, Collection<String> var3, String var4) throws DirectoryPermissionException, RemoteException, ObjectNotFoundException;
}

