/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.integration.SearchContext;
import com.atlassian.crowd.integration.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.PrincipalAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidPrincipalException;
import com.atlassian.crowd.integration.exception.InvalidRoleException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.AttributeValues;
import com.atlassian.crowd.integration.model.RemoteGroup;
import com.atlassian.crowd.integration.model.RemotePrincipal;
import com.atlassian.crowd.integration.model.RemoteRole;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.manager.application.ApplicationServiceException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.token.Token;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;

public interface ApplicationService {
    public RemoteGroup addGroup(Application var1, RemoteGroup var2) throws ApplicationServiceException, RemoteException, InvalidGroupException, ApplicationPermissionException;

    public RemotePrincipal addPrincipal(Application var1, RemotePrincipal var2) throws InvalidPrincipalException, RemoteException, InvalidCredentialException, ApplicationPermissionException;

    public void addPrincipalAttribute(Application var1, String var2, String var3, AttributeValues var4) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException;

    public void addPrincipalToGroup(Application var1, String var2, String var3) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException;

    public void addPrincipalToRole(Application var1, String var2, String var3) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException;

    public RemoteRole addRole(Application var1, RemoteRole var2) throws RemoteException, InvalidRoleException, ApplicationPermissionException;

    public Token authenticate(ApplicationAuthenticationContext var1) throws ApplicationServiceException, InvalidAuthenticationException;

    public Token authenticate(PrincipalAuthenticationContext var1) throws ApplicationServiceException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ApplicationAccessDeniedException;

    public Token authenticate(PrincipalAuthenticationContext var1, boolean var2) throws ApplicationServiceException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ApplicationAccessDeniedException;

    public Token authenticateIgnoreCache(PrincipalAuthenticationContext var1) throws ApplicationServiceException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ApplicationAccessDeniedException;

    public RemoteGroup findGroupByName(Application var1, String var2) throws ObjectNotFoundException, RemoteException;

    public List findGroupMemberships(Application var1, String var2) throws RemoteException, ObjectNotFoundException;

    public RemotePrincipal findPrincipalByName(Application var1, String var2) throws ApplicationServiceException, ObjectNotFoundException, RemoteException;

    public RemoteRole findRoleByName(Application var1, String var2) throws ObjectNotFoundException, RemoteException;

    public List findRoleMemberships(Application var1, String var2) throws RemoteException, ObjectNotFoundException;

    public boolean isGroupMember(Application var1, String var2, String var3) throws RemoteException;

    public boolean isRoleMember(Application var1, String var2, String var3) throws RemoteException;

    public void removeGroup(Application var1, String var2) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException;

    public void removePrincipal(Application var1, String var2) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException;

    public void removePrincipalAttribute(Application var1, String var2, String var3) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException;

    public void removePrincipalFromGroup(Application var1, String var2, String var3) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException;

    public void removePrincipalFromRole(Application var1, String var2, String var3) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException;

    public void removeRole(Application var1, String var2) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException;

    public void resetPrincipalCredential(Application var1, String var2) throws RemoteException, InvalidEmailAddressException, ObjectNotFoundException, InvalidCredentialException, ApplicationPermissionException, InvalidEmailAddressException;

    public Collection searchGroups(Application var1, SearchContext var2) throws RemoteException;

    public Collection searchPrincipals(Application var1, SearchContext var2) throws RemoteException;

    public Collection searchRoles(Application var1, SearchContext var2) throws RemoteException;

    public void updateGroup(Application var1, String var2, String var3, boolean var4) throws RemoteException, ApplicationPermissionException, ObjectNotFoundException;

    public void updatePrincipalAttribute(Application var1, String var2, String var3, AttributeValues var4) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException;

    public void updatePrincipalCredential(Application var1, String var2, PasswordCredential var3) throws RemoteException, ObjectNotFoundException, InvalidCredentialException, ApplicationPermissionException;

    public void updateRole(Application var1, String var2, String var3, boolean var4) throws RemoteException, ApplicationPermissionException, ObjectNotFoundException;

    public Token validateToken(String var1, ValidationFactor[] var2) throws ApplicationServiceException, InvalidTokenException;

    public Token validateToken(String var1, ValidationFactor[] var2, String var3) throws ApplicationServiceException, InvalidTokenException, RemoteException, ApplicationAccessDeniedException;
}

