/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model;

import com.atlassian.crowd.integration.model.AttributeValues;
import com.atlassian.crowd.integration.model.NamedEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryEntity
implements Serializable,
Comparable<DirectoryEntity>,
NamedEntity {
    protected long ID = -1L;
    protected String name;
    protected long directoryID;
    protected String description;
    protected boolean active;
    protected Date conception;
    protected Map<String, AttributeValues> attributes;
    protected Date lastModified;

    protected DirectoryEntity() {
    }

    protected DirectoryEntity(DirectoryEntity directoryEntity) {
        this.setName(directoryEntity.getName());
        this.setActive(directoryEntity.isActive());
        this.setDirectoryID(directoryEntity.getDirectoryID());
        Date conception = directoryEntity.getConception();
        if (conception != null) {
            this.setConception(new Date(conception.getTime()));
        } else {
            this.setConception(new Date());
        }
        Date lastModified = directoryEntity.getLastModified();
        if (lastModified != null) {
            this.setLastModified(new Date(lastModified.getTime()));
        } else {
            this.setLastModified(new Date());
        }
        this.setDescription(directoryEntity.getDescription());
        HashMap<String, AttributeValues> attributes = new HashMap<String, AttributeValues>();
        for (Map.Entry<String, AttributeValues> entry : directoryEntity.getAttributes().entrySet()) {
            String key = entry.getKey();
            AttributeValues values = entry.getValue();
            attributes.put(key, new AttributeValues(new ArrayList<String>(values.getValues())));
        }
        this.setAttributes(attributes);
    }

    public long getID() {
        return this.ID;
    }

    public void setID(long ID) {
        this.ID = ID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getDirectoryID() {
        return this.directoryID;
    }

    public void setDirectoryID(long directoryID) {
        this.directoryID = directoryID;
    }

    public Map<String, AttributeValues> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, AttributeValues>();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, AttributeValues> attributes) {
        this.attributes = attributes;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Date getConception() {
        return this.conception;
    }

    public void setConception(Date conception) {
        this.conception = conception;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public AttributeValues getAttribute(String key) {
        AttributeValues attributeValues = this.getAttributes().get(key);
        if (attributeValues == null) {
            return new AttributeValues();
        }
        return attributeValues;
    }

    public String getSingleAttributeValue(String key) {
        AttributeValues attributeValues = this.getAttributes().get(key);
        String value = null;
        if (attributeValues != null && attributeValues.getValues() != null && attributeValues.getValues().size() > 0) {
            value = attributeValues.getValues().get(0);
        }
        return value;
    }

    public long getSingleAttributeLongValue(String key) {
        String value = this.getSingleAttributeValue(key);
        if (value == null) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    protected boolean getAttributeBooleanValue(String key) {
        String flag = this.getSingleAttributeValue(key);
        if (flag == null) {
            return false;
        }
        return flag.toLowerCase().equals("true");
    }

    public void setAttribute(String key, String newValue) {
        AttributeValues existingValues = this.getAttributes().get(key);
        if (existingValues != null) {
            if (existingValues.getValues().size() != 1 || !existingValues.getValues().get(0).equals(newValue)) {
                existingValues.setSingleValue(newValue);
            }
        } else if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)newValue)) {
            AttributeValues values = new AttributeValues();
            values.addValue(newValue);
            this.setOrReplaceAttribute(key, values);
        }
    }

    public void setOrReplaceAttribute(String key, AttributeValues values) {
        if (values == null || values.getValues().isEmpty()) {
            this.getAttributes().remove(key);
        } else {
            this.getAttributes().put(key, values);
        }
    }

    public void setOrReplaceAttribute(String key, List<String> values) {
        AttributeValues attributeValues = new AttributeValues();
        attributeValues.setValues(values);
        this.setOrReplaceAttribute(key, attributeValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectoryEntity)) {
            return false;
        }
        DirectoryEntity that = (DirectoryEntity)o;
        if (this.getName() != null && that.getName() == null) {
            return false;
        }
        return !(this.getName() != null ? !this.getName().toLowerCase().equals(that.getName().toLowerCase()) : that.getName() != null);
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().toLowerCase().hashCode() : 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("ID", this.getID()).append("name", (Object)this.getName()).append("directoryID", this.getDirectoryID()).append("active", this.isActive()).append("conception", (Object)this.getConception()).append("lastModified", (Object)this.getLastModified()).toString();
    }

    @Override
    public int compareTo(DirectoryEntity o) {
        return String.CASE_INSENSITIVE_ORDER.compare(this.getName(), o.getName());
    }
}

